/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
  * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
  */

/*
 * $Id: DataTypes.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.types.auto;

import javax.persistence.*;

@Entity
@Table(name = "DATATYPES")
public class DataTypes implements java.io.Serializable {
    
    private Integer id;
    private Character characterData;
    private Short shortData;
    private Integer integerData;       
    private Long longData;
    private Double doubleData;
    private Float floatData;
    
    public DataTypes()
    {
    }

    public DataTypes(Character characterData, Short shortData, Integer integerData,
			Long longData, Double doubleData, Float floatData)
    {
        this.characterData = characterData;
        this.shortData = shortData;
        this.integerData = integerData;
        this.longData = longData;
        this.doubleData = doubleData;
        this.floatData = floatData;
    }

   @Id
   @GeneratedValue(strategy = GenerationType.AUTO)
   public Integer getId()
   {
      return id;
   }
   public void setId(Integer id)
   {
      this.id= id;
   }
   
   @Column(name = "CHARDATA")
   public Character getCharacterData()
   {
      return characterData;
   }
   public void setCharacterData(Character characterData)
   {
      this.characterData = characterData;
   }
    
   @Column(name = "SHORTDATA")
   public Short getShortData(){
      return shortData;
   }
   public void setShortData(Short shortData)
   {
      this.shortData = shortData;
   }

   @Column(name = "INTDATA")
   public Integer getIntegerData() {
       return integerData;
   }
   public void setIntegerData(Integer integerData)
   {
      this.integerData = integerData;
   }
    
   @Column(name = "LONGDATA")
   public Long getLongData()
   {
        return longData;
   }
   public void setLongData(Long longData)
   {
      this.longData = longData;
   }
    
   @Column(name = "DBLDATA")
   public Double getDoubleData()
   {
        return doubleData;
   }
   public void setDoubleData(Double doubleData)
   {
      this.doubleData = doubleData;
   }

   @Column(name = "FLOATDATA")
   public Float getFloatData()
   {
        return floatData;
   }
   public void setFloatData(Float floatData)
   {
      this.floatData = floatData;
   }
    
    
}
