/*
 * Copyright (c) 2009, 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.se.cache.inherit;

import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

/*
 * SoftwareProduct
 */


@Entity
@Cacheable(true)
@DiscriminatorValue("SW2")
public class SoftwareProduct2 extends Product2
        implements java.io.Serializable {
	private static final long serialVersionUID = 22L;
	
	// Instance variables
    private double revisionNumber;

    public SoftwareProduct2() {
        super();
    }


    // ===========================================================
    // getters and setters for the state fields


    @Column(name = "REV", nullable = true)
    public double getRevisionNumber() {
        return revisionNumber;
    }

    public void setRevisionNumber(double revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        result.append(", revisionNumber: " + getRevisionNumber());
        result.append(", quantity: " + getQuantity());
        result.append("]");
        return result.toString();
    }
}

