/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.KeyDataPair;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnectionImpl;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.WebResponseImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.SimpleLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpWebConnection
extends WebConnectionImpl {
    private HttpClient httpClient_;
    private String virtualHost_;

    public HttpWebConnection(WebClient webClient) {
        super(webClient);
    }

    @Override
    public WebResponse getResponse(WebRequestSettings webRequestSettings) throws IOException {
        URL url = webRequestSettings.getUrl();
        HttpClient httpClient = this.getHttpClient();
        HttpMethodBase httpMethod = this.makeHttpMethod(webRequestSettings);
        try {
            HostConfiguration hostConfiguration = this.getHostConfiguration(webRequestSettings);
            long startTime = System.currentTimeMillis();
            int responseCode = httpClient.executeMethod(hostConfiguration, (org.apache.commons.httpclient.HttpMethod)httpMethod);
            long endTime = System.currentTimeMillis();
            WebResponse webResponse = this.makeWebResponse(responseCode, httpMethod, webRequestSettings, endTime - startTime, webRequestSettings.getCharset());
            return webResponse;
        }
        catch (HttpException e) {
            if (url.getPath().length() == 0) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(url.getProtocol());
                buffer.append("://");
                buffer.append(url.getHost());
                buffer.append("/");
                if (url.getQuery() != null) {
                    buffer.append(url.getQuery());
                }
                WebRequestSettings newRequest = new WebRequestSettings(new URL(buffer.toString()));
                newRequest.setHttpMethod(webRequestSettings.getHttpMethod());
                newRequest.setRequestParameters(webRequestSettings.getRequestParameters());
                newRequest.setAdditionalHeaders(webRequestSettings.getAdditionalHeaders());
                WebResponse webResponse = this.getResponse(newRequest);
                return webResponse;
            }
            e.printStackTrace();
            throw new RuntimeException("HTTP Error: " + e.getMessage());
        }
        finally {
            this.onResponseGenerated(httpMethod);
        }
    }

    protected void onResponseGenerated(HttpMethodBase httpMethod) {
        httpMethod.releaseConnection();
    }

    private HostConfiguration getHostConfiguration(WebRequestSettings webRequestSettings) {
        URI uri;
        HostConfiguration hostConfiguration = new HostConfiguration();
        URL url = webRequestSettings.getUrl();
        try {
            uri = new URI(url.toExternalForm(), false);
        }
        catch (URIException e) {
            throw new IllegalStateException("Unable to create URI from URL: " + url.toExternalForm());
        }
        hostConfiguration.setHost(uri);
        if (webRequestSettings.getProxyHost() != null) {
            String proxyHost = webRequestSettings.getProxyHost();
            int proxyPort = webRequestSettings.getProxyPort();
            hostConfiguration.setProxy(proxyHost, proxyPort);
        }
        return hostConfiguration;
    }

    private HttpMethodBase makeHttpMethod(WebRequestSettings webRequestSettings) throws IOException {
        String path = webRequestSettings.getUrl().getPath();
        if (path.length() == 0) {
            path = "/";
        } else if (path.startsWith("//")) {
            path = "//" + path;
        }
        HttpMethodBase httpMethod = this.buildHttpMethod(webRequestSettings.getHttpMethod(), path);
        if (!(httpMethod instanceof EntityEnclosingMethod)) {
            if (webRequestSettings.getRequestParameters().isEmpty()) {
                String queryString = webRequestSettings.getUrl().getQuery();
                httpMethod.setQueryString(queryString);
            } else {
                NameValuePair[] pairs = new NameValuePair[webRequestSettings.getRequestParameters().size()];
                webRequestSettings.getRequestParameters().toArray(pairs);
                httpMethod.setQueryString(pairs);
            }
        } else {
            String body;
            EntityEnclosingMethod method = (EntityEnclosingMethod)httpMethod;
            method.getParams().setContentCharset(webRequestSettings.getCharset());
            String queryString = webRequestSettings.getUrl().getQuery();
            if (queryString != null) {
                method.setQueryString(queryString);
            }
            if (webRequestSettings.getRequestBody() != null) {
                body = webRequestSettings.getRequestBody();
                String charset = webRequestSettings.getCharset();
                method.setRequestEntity((RequestEntity)new StringRequestEntity(body, null, charset));
            }
            if (webRequestSettings.getEncodingType() == FormEncodingType.URL_ENCODED && method instanceof PostMethod) {
                PostMethod postMethod = (PostMethod)httpMethod;
                for (NameValuePair pair : webRequestSettings.getRequestParameters()) {
                    postMethod.removeParameter(pair.getName(), pair.getValue());
                }
                for (NameValuePair pair : webRequestSettings.getRequestParameters()) {
                    postMethod.addParameter(pair.getName(), pair.getValue());
                }
            } else if (FormEncodingType.MULTIPART == webRequestSettings.getEncodingType()) {
                ArrayList<StringPart> partList = new ArrayList<StringPart>();
                for (NameValuePair pair : webRequestSettings.getRequestParameters()) {
                    StringPart newPart;
                    if (pair instanceof KeyDataPair) {
                        KeyDataPair pairWithFile = (KeyDataPair)pair;
                        String charset = webRequestSettings.getCharset();
                        newPart = this.buildFilePart(pairWithFile, charset);
                    } else {
                        newPart = new StringPart(pair.getName(), pair.getValue(), webRequestSettings.getCharset());
                        newPart.setContentType(null);
                    }
                    newPart.setTransferEncoding(null);
                    partList.add(newPart);
                }
                Part[] parts = new Part[partList.size()];
                parts = partList.toArray(parts);
                method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
            } else {
                body = webRequestSettings.getRequestBody();
                String contentType = webRequestSettings.getAdditionalHeaders().get("Content-type");
                String charset = webRequestSettings.getCharset();
                method.setRequestEntity((RequestEntity)new StringRequestEntity(body, contentType, charset));
            }
        }
        httpMethod.setRequestHeader("User-Agent", this.getWebClient().getBrowserVersion().getUserAgent());
        this.writeRequestHeadersToHttpMethod((org.apache.commons.httpclient.HttpMethod)httpMethod, webRequestSettings.getAdditionalHeaders());
        httpMethod.setFollowRedirects(false);
        if (webRequestSettings.getCredentialsProvider() != null) {
            httpMethod.getParams().setParameter("http.authentication.credential-provider", (Object)webRequestSettings.getCredentialsProvider());
        }
        if (this.getWebClient().isCookiesEnabled()) {
            httpMethod.getParams().setBooleanParameter("http.protocol.single-cookie-header", true);
            httpMethod.getParams().setCookiePolicy("compatibility");
        } else {
            httpMethod.getParams().setCookiePolicy("ignoreCookies");
        }
        return httpMethod;
    }

    FilePart buildFilePart(KeyDataPair pairWithFile, String charset) throws FileNotFoundException {
        FilePartPageCharSet part = pairWithFile.getData() != null ? new FilePartPageCharSet(pairWithFile.getName(), new ByteArrayPartSource(pairWithFile.getValue(), pairWithFile.getData()), pairWithFile.getContentType(), charset) : new FilePartPageCharSet(pairWithFile.getName(), pairWithFile.getValue(), pairWithFile.getFile(), pairWithFile.getContentType(), charset);
        part.pairWithFile_ = pairWithFile;
        part.webClient_ = this.getWebClient();
        part.setCharSet(null);
        return part;
    }

    private HttpMethodBase buildHttpMethod(HttpMethod submitMethod, String path) {
        GetMethod method;
        switch (submitMethod) {
            case GET: {
                method = new GetMethod(path);
                break;
            }
            case POST: {
                method = new PostMethod(path);
                break;
            }
            case PUT: {
                method = new PutMethod(path);
                break;
            }
            case DELETE: {
                method = new DeleteMethod(path);
                break;
            }
            case OPTIONS: {
                method = new OptionsMethod(path);
                break;
            }
            case HEAD: {
                method = new HeadMethod(path);
                break;
            }
            case TRACE: {
                method = new TraceMethod(path);
                break;
            }
            default: {
                throw new IllegalStateException("Submit method not yet supported: " + (Object)((Object)submitMethod));
            }
        }
        return method;
    }

    protected synchronized HttpClient getHttpClient() {
        if (this.httpClient_ == null) {
            this.httpClient_ = this.createHttpClient();
            Log log = LogFactory.getLog((String)"httpclient.wire");
            if (log instanceof SimpleLog) {
                ((SimpleLog)log).setLevel(4);
            }
            this.httpClient_.getHttpConnectionManager().getParams().setSoTimeout(this.getTimeout());
            this.httpClient_.getHttpConnectionManager().getParams().setConnectionTimeout(this.getTimeout());
            if (this.virtualHost_ != null) {
                this.httpClient_.getParams().setVirtualHost(this.virtualHost_);
            }
        }
        this.httpClient_.getParams().setParameter("http.authentication.credential-provider", (Object)this.getWebClient().getCredentialsProvider());
        return this.httpClient_;
    }

    protected int getTimeout() {
        return this.getWebClient().getTimeout();
    }

    protected HttpClient createHttpClient() {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        return new HttpClient((HttpConnectionManager)connectionManager);
    }

    protected final Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost_ = virtualHost;
    }

    public String getVirtualHost() {
        return this.virtualHost_;
    }

    @Override
    public HttpState getState() {
        return this.getHttpClient().getState();
    }

    private WebResponse makeWebResponse(int statusCode, HttpMethodBase method, WebRequestSettings requestSettings, long loadTime, String charset) throws IOException {
        String statusMessage = method.getStatusText();
        if (statusMessage == null || statusMessage.length() == 0) {
            statusMessage = HttpStatus.getStatusText((int)statusCode);
        }
        if (statusMessage == null) {
            statusMessage = "Unknown status code";
        }
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        for (Header header : method.getResponseHeaders()) {
            headers.add(new NameValuePair(header.getName(), header.getValue()));
        }
        WebResponseData responseData = this.newWebResponseDataInstance(statusMessage, headers, statusCode, method);
        return this.newWebResponseInstance(charset, responseData, loadTime, requestSettings);
    }

    protected WebResponseData newWebResponseDataInstance(String statusMessage, List<NameValuePair> headers, int statusCode, HttpMethodBase method) throws IOException {
        return new WebResponseData(method.getResponseBodyAsStream(), statusCode, statusMessage, headers);
    }

    @Deprecated
    protected WebResponse newWebResponseInstance(String charset, WebResponseData responseData, long loadTime, SubmitMethod requestMethod, URL originatingURL) {
        return new WebResponseImpl(responseData, charset, originatingURL, requestMethod, loadTime);
    }

    protected WebResponse newWebResponseInstance(String charset, WebResponseData responseData, long loadTime, WebRequestSettings requestSettings) {
        return new WebResponseImpl(responseData, charset, requestSettings, loadTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequestHeadersToHttpMethod(org.apache.commons.httpclient.HttpMethod httpMethod, Map<String, String> requestHeaders) {
        Map<String, String> map = requestHeaders;
        synchronized (map) {
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                httpMethod.setRequestHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private static class FilePartPageCharSet
    extends FilePart {
        private KeyDataPair pairWithFile_;
        private WebClient webClient_;
        private String pageCharset_;

        public FilePartPageCharSet(String name, ByteArrayPartSource byteArrayPartSource, String contentType, String charset) {
            super(name, (PartSource)byteArrayPartSource, contentType, charset);
            this.pageCharset_ = charset;
        }

        public FilePartPageCharSet(String name, String value, File file, String contentType, String charset) throws FileNotFoundException {
            super(name, value, file, contentType, charset);
            this.pageCharset_ = charset;
        }

        protected void sendDispositionHeader(OutputStream out) throws IOException {
            out.write(CONTENT_DISPOSITION_BYTES);
            out.write(QUOTE_BYTES);
            out.write(EncodingUtil.getAsciiBytes((String)this.getName()));
            out.write(QUOTE_BYTES);
            String filename = this.getSource().getFileName();
            if (filename != null) {
                out.write(EncodingUtil.getAsciiBytes((String)"; filename="));
                out.write(QUOTE_BYTES);
                out.write(EncodingUtil.getBytes((String)this.getFileName(), (String)this.pageCharset_));
                out.write(QUOTE_BYTES);
            }
        }

        private String getFileName() {
            if (this.pairWithFile_.getFile() == null) {
                return this.pairWithFile_.getValue();
            }
            if (this.webClient_.getBrowserVersion().isIE()) {
                return this.pairWithFile_.getFile().getAbsolutePath();
            }
            return this.pairWithFile_.getValue();
        }
    }
}

