/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ObjectInstantiationException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DefaultElementFactory;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HTMLErrorHandler;
import com.gargoylesoftware.htmlunit.html.HTMLParserListener;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlFrameSet;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.IElementFactory;
import com.gargoylesoftware.htmlunit.html.InputElementFactory;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.html.UnknownElementFactory;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLBodyElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.HTMLEventInfo;
import org.cyberneko.html.HTMLTagBalancingListener;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class HTMLParser {
    private static final Map<String, IElementFactory> ELEMENT_FACTORIES = new HashMap<String, IElementFactory>();
    private static boolean IgnoreOutsideContent_;

    public static void setIgnoreOutsideContent(boolean ignoreOutsideContent) {
        IgnoreOutsideContent_ = ignoreOutsideContent;
    }

    public static boolean getIgnoreOutsideContent() {
        return IgnoreOutsideContent_;
    }

    public static IElementFactory getFactory(String tagName) {
        IElementFactory result = ELEMENT_FACTORIES.get(tagName);
        if (result != null) {
            return result;
        }
        return UnknownElementFactory.instance;
    }

    private HTMLParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseFragment(DomNode parent, String source) throws SAXException, IOException {
        HtmlPage page = (HtmlPage)parent.getPage();
        URL url = page.getWebResponse().getUrl();
        HtmlUnitDOMBuilder domBuilder = new HtmlUnitDOMBuilder(parent, url);
        domBuilder.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
        XMLInputSource in = new XMLInputSource(null, url.toString(), null, (Reader)new StringReader(source), null);
        try {
            page.registerParsingStart();
            page.registerSnippetParsingStart();
            domBuilder.parse(in);
        }
        finally {
            page.registerParsingEnd();
            page.registerSnippetParsingEnd();
        }
    }

    public static HtmlPage parse(WebResponse webResponse, WebWindow webWindow) throws IOException {
        URL url = webResponse.getUrl();
        HtmlPage page = new HtmlPage(url, webResponse, webWindow);
        webWindow.setEnclosedPage(page);
        HtmlUnitDOMBuilder domBuilder = new HtmlUnitDOMBuilder(page, webResponse.getUrl());
        String charSet = webResponse.getContentCharSet();
        InputStream content = webResponse.getContentAsStream();
        XMLInputSource in = new XMLInputSource(null, url.toString(), null, content, charSet);
        try {
            page.registerParsingStart();
            domBuilder.parse(in);
        }
        catch (XNIException e) {
            Throwable origin = HTMLParser.extractNestedException(e);
            throw new RuntimeException("Failed parsing content from " + webResponse.getUrl(), origin);
        }
        finally {
            page.registerParsingEnd();
        }
        HTMLParser.addBodyToPageIfNecessary(page, true);
        return page;
    }

    private static void addBodyToPageIfNecessary(HtmlPage page, boolean originalCall) {
        boolean ie = page.getWebClient().getBrowserVersion().isIE();
        if (page.getEnclosingWindow() instanceof FrameWindow && ie && originalCall) {
            return;
        }
        HtmlElement doc = page.getDocumentElement();
        boolean hasBody = false;
        for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof HtmlBody) && !(child instanceof HtmlFrameSet)) continue;
            hasBody = true;
            break;
        }
        if (!hasBody) {
            HtmlBody body = new HtmlBody(null, "body", page, null, false);
            doc.appendChild(body);
        }
        if (ie) {
            for (FrameWindow frame : page.getFrames()) {
                Page containedPage = frame.getEnclosedPage();
                if (!(containedPage instanceof HtmlPage)) continue;
                HTMLParser.addBodyToPageIfNecessary((HtmlPage)containedPage, false);
            }
        }
    }

    static Throwable extractNestedException(Throwable e) {
        Throwable originalException = e;
        Throwable cause = ((XNIException)e).getException();
        while (cause != null) {
            originalException = cause;
            if (cause instanceof XNIException) {
                cause = ((XNIException)cause).getException();
                continue;
            }
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
                continue;
            }
            cause = null;
        }
        return originalException;
    }

    static {
        ELEMENT_FACTORIES.put("input", InputElementFactory.instance);
        DefaultElementFactory defaultElementFactory = new DefaultElementFactory();
        ELEMENT_FACTORIES.put("a", defaultElementFactory);
        ELEMENT_FACTORIES.put("applet", defaultElementFactory);
        ELEMENT_FACTORIES.put("address", defaultElementFactory);
        ELEMENT_FACTORIES.put("area", defaultElementFactory);
        ELEMENT_FACTORIES.put("base", defaultElementFactory);
        ELEMENT_FACTORIES.put("basefont", defaultElementFactory);
        ELEMENT_FACTORIES.put("bdo", defaultElementFactory);
        ELEMENT_FACTORIES.put("blockquote", defaultElementFactory);
        ELEMENT_FACTORIES.put("body", defaultElementFactory);
        ELEMENT_FACTORIES.put("br", defaultElementFactory);
        ELEMENT_FACTORIES.put("button", defaultElementFactory);
        ELEMENT_FACTORIES.put("caption", defaultElementFactory);
        ELEMENT_FACTORIES.put("center", defaultElementFactory);
        ELEMENT_FACTORIES.put("col", defaultElementFactory);
        ELEMENT_FACTORIES.put("colgroup", defaultElementFactory);
        ELEMENT_FACTORIES.put("dd", defaultElementFactory);
        ELEMENT_FACTORIES.put("del", defaultElementFactory);
        ELEMENT_FACTORIES.put("dir", defaultElementFactory);
        ELEMENT_FACTORIES.put("div", defaultElementFactory);
        ELEMENT_FACTORIES.put("dl", defaultElementFactory);
        ELEMENT_FACTORIES.put("dt", defaultElementFactory);
        ELEMENT_FACTORIES.put("fieldset", defaultElementFactory);
        ELEMENT_FACTORIES.put("font", defaultElementFactory);
        ELEMENT_FACTORIES.put("form", defaultElementFactory);
        ELEMENT_FACTORIES.put("frame", defaultElementFactory);
        ELEMENT_FACTORIES.put("frameset", defaultElementFactory);
        ELEMENT_FACTORIES.put("h1", defaultElementFactory);
        ELEMENT_FACTORIES.put("h2", defaultElementFactory);
        ELEMENT_FACTORIES.put("h3", defaultElementFactory);
        ELEMENT_FACTORIES.put("h4", defaultElementFactory);
        ELEMENT_FACTORIES.put("h5", defaultElementFactory);
        ELEMENT_FACTORIES.put("h6", defaultElementFactory);
        ELEMENT_FACTORIES.put("head", defaultElementFactory);
        ELEMENT_FACTORIES.put("hr", defaultElementFactory);
        ELEMENT_FACTORIES.put("html", defaultElementFactory);
        ELEMENT_FACTORIES.put("iframe", defaultElementFactory);
        ELEMENT_FACTORIES.put("img", defaultElementFactory);
        ELEMENT_FACTORIES.put("ins", defaultElementFactory);
        ELEMENT_FACTORIES.put("isindex", defaultElementFactory);
        ELEMENT_FACTORIES.put("label", defaultElementFactory);
        ELEMENT_FACTORIES.put("legend", defaultElementFactory);
        ELEMENT_FACTORIES.put("li", defaultElementFactory);
        ELEMENT_FACTORIES.put("link", defaultElementFactory);
        ELEMENT_FACTORIES.put("map", defaultElementFactory);
        ELEMENT_FACTORIES.put("menu", defaultElementFactory);
        ELEMENT_FACTORIES.put("meta", defaultElementFactory);
        ELEMENT_FACTORIES.put("noframes", defaultElementFactory);
        ELEMENT_FACTORIES.put("noscript", defaultElementFactory);
        ELEMENT_FACTORIES.put("object", defaultElementFactory);
        ELEMENT_FACTORIES.put("ol", defaultElementFactory);
        ELEMENT_FACTORIES.put("optgroup", defaultElementFactory);
        ELEMENT_FACTORIES.put("option", defaultElementFactory);
        ELEMENT_FACTORIES.put("p", defaultElementFactory);
        ELEMENT_FACTORIES.put("param", defaultElementFactory);
        ELEMENT_FACTORIES.put("pre", defaultElementFactory);
        ELEMENT_FACTORIES.put("q", defaultElementFactory);
        ELEMENT_FACTORIES.put("script", defaultElementFactory);
        ELEMENT_FACTORIES.put("select", defaultElementFactory);
        ELEMENT_FACTORIES.put("span", defaultElementFactory);
        ELEMENT_FACTORIES.put("style", defaultElementFactory);
        ELEMENT_FACTORIES.put("title", defaultElementFactory);
        ELEMENT_FACTORIES.put("table", defaultElementFactory);
        ELEMENT_FACTORIES.put("tbody", defaultElementFactory);
        ELEMENT_FACTORIES.put("td", defaultElementFactory);
        ELEMENT_FACTORIES.put("th", defaultElementFactory);
        ELEMENT_FACTORIES.put("tr", defaultElementFactory);
        ELEMENT_FACTORIES.put("textarea", defaultElementFactory);
        ELEMENT_FACTORIES.put("tfoot", defaultElementFactory);
        ELEMENT_FACTORIES.put("thead", defaultElementFactory);
        ELEMENT_FACTORIES.put("ul", defaultElementFactory);
    }

    static final class HtmlUnitDOMBuilder
    extends AbstractSAXParser
    implements ContentHandler,
    LexicalHandler,
    HTMLTagBalancingListener {
        private final HtmlPage page_;
        private Locator locator_;
        private final Stack<DomNode> stack_ = new Stack();
        private DomNode currentNode_;
        private StringBuilder characters_;
        private boolean headParsed_ = false;
        private HtmlElement body_;
        private Augmentations augmentations_;
        private HtmlForm formWaitingForLostChildren_;
        private static final String FEATURE_AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";

        public void pushInputString(String sourceString) {
            WebResponse webResponse = this.page_.getWebResponse();
            String charSet = webResponse.getContentCharSet();
            XMLInputSource in = new XMLInputSource(null, webResponse.getUrl().toString(), null, (Reader)new StringReader(sourceString), charSet);
            ((HTMLConfiguration)this.fConfiguration).evaluateInputSource(in);
        }

        private HtmlUnitDOMBuilder(DomNode page, URL url) {
            super((XMLParserConfiguration)new HTMLConfiguration());
            boolean reportErrors;
            this.page_ = (HtmlPage)page.getPage();
            this.currentNode_ = page;
            this.stack_.push(this.currentNode_);
            HTMLParserListener listener = this.page_.getWebClient().getHTMLParserListener();
            if (listener != null) {
                reportErrors = true;
                this.fConfiguration.setErrorHandler((XMLErrorHandler)new HTMLErrorHandler(listener, url));
            } else {
                reportErrors = false;
            }
            try {
                this.setFeature(FEATURE_AUGMENTATIONS, true);
                this.setProperty("http://cyberneko.org/html/properties/names/elems", "lower");
                this.setFeature("http://cyberneko.org/html/features/report-errors", reportErrors);
                this.setFeature("http://cyberneko.org/html/features/balance-tags/ignore-outside-content", IgnoreOutsideContent_);
                this.setContentHandler(this);
                this.setLexicalHandler(this);
            }
            catch (SAXException e) {
                throw new ObjectInstantiationException("unable to create HTML parser", e);
            }
        }

        public Locator getLocator() {
            return this.locator_;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator_ = locator;
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            HtmlElement newElement;
            IElementFactory factory;
            this.handleCharacters();
            String tagLower = localName.toLowerCase();
            if (tagLower.equals("head")) {
                this.headParsed_ = true;
            } else if (!this.headParsed_ && (tagLower.equals("body") || tagLower.equals("frameset"))) {
                factory = this.getElementFactory("head");
                newElement = factory.createElement(this.page_, "head", null);
                this.currentNode_.appendChild(newElement);
                this.headParsed_ = true;
            } else if (tagLower.equals("tr") && this.currentNode_.getNodeName().equals("table")) {
                factory = this.getElementFactory("tbody");
                newElement = factory.createElement(this.page_, "tbody", null);
                this.currentNode_.appendChild(newElement);
                this.currentNode_ = newElement;
                this.stack_.push(this.currentNode_);
            }
            HtmlBody oldBody = null;
            if (tagLower.equals("body") && this.page_.getBody() instanceof HtmlBody) {
                oldBody = (HtmlBody)this.page_.getBody();
            }
            IElementFactory factory2 = this.getElementFactory(tagLower);
            HtmlElement newElement2 = factory2.createElement(this.page_, tagLower, atts);
            newElement2.setStartLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
            this.currentNode_.appendChild(newElement2);
            if (oldBody != null) {
                oldBody.quietlyRemoveAndMoveChildrenTo(newElement2);
            }
            if (tagLower.equals("body")) {
                this.body_ = newElement2;
            }
            this.currentNode_ = newElement2;
            this.stack_.push(this.currentNode_);
        }

        public void endElement(QName element, Augmentations augs) throws XNIException {
            this.augmentations_ = augs;
            super.endElement(element, augs);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.handleCharacters();
            DomNode previousNode = this.stack_.pop();
            previousNode.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
            if (previousNode instanceof HtmlForm && ((HTMLEventInfo)this.augmentations_.getItem(FEATURE_AUGMENTATIONS)).isSynthesized()) {
                this.formWaitingForLostChildren_ = (HtmlForm)previousNode;
            } else if (this.formWaitingForLostChildren_ != null && previousNode instanceof SubmittableElement) {
                this.formWaitingForLostChildren_.addLostChild((HtmlElement)previousNode);
            }
            if (!this.currentNode_.getNodeName().equalsIgnoreCase(localName)) {
                this.stack_.pop();
            }
            if (!this.stack_.isEmpty()) {
                this.currentNode_ = this.stack_.peek();
            }
            previousNode.onAllChildrenAddedToPage();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.characters_ == null) {
                this.characters_ = new StringBuilder();
            }
            this.characters_.append(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.characters_ == null) {
                this.characters_ = new StringBuilder();
            }
            this.characters_.append(ch, start, length);
        }

        private void handleCharacters() {
            if (this.characters_ != null && this.characters_.length() > 0) {
                DomText text = new DomText(this.page_, this.characters_.toString());
                this.characters_.setLength(0);
                this.currentNode_.appendChild(text);
            }
        }

        private IElementFactory getElementFactory(String tagName) {
            IElementFactory factory = (IElementFactory)ELEMENT_FACTORIES.get(tagName);
            if (factory != null) {
                return factory;
            }
            return UnknownElementFactory.instance;
        }

        public void endDocument() throws SAXException {
            this.handleCharacters();
            HtmlPage currentPage = this.page_;
            currentPage.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void comment(char[] ch, int start, int length) {
            this.handleCharacters();
            DomComment comment = new DomComment(this.page_, String.valueOf(ch, start, length));
            this.currentNode_.appendChild(comment);
        }

        public void endCDATA() {
        }

        public void endDTD() {
        }

        public void endEntity(String name) {
        }

        public void startCDATA() {
        }

        public void startDTD(String name, String publicId, String systemId) {
        }

        public void startEntity(String name) {
        }

        public void ignoredEndElement(QName element, Augmentations augs) {
            if (this.formWaitingForLostChildren_ != null && "form".equals(element.localpart)) {
                this.formWaitingForLostChildren_ = null;
            }
        }

        public void ignoredStartElement(QName elem, XMLAttributes attrs, Augmentations augs) {
            if (this.body_ != null && "body".equalsIgnoreCase(elem.localpart) && attrs != null) {
                int length = attrs.getLength();
                for (int i = 0; i < length; ++i) {
                    String attrName = attrs.getLocalName(i).toLowerCase();
                    if (this.body_.getAttributes().getNamedItem(attrName) != null) continue;
                    this.body_.setAttribute(attrName, attrs.getValue(i));
                    if (!attrName.startsWith("on") || this.body_.getScriptObject() == null) continue;
                    HTMLBodyElement jsBody = (HTMLBodyElement)this.body_.getScriptObject();
                    jsBody.createEventHandlerFromAttribute(attrName, attrs.getValue(i));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse(XMLInputSource inputSource) throws XNIException, IOException {
            this.page_.setBuilder(this);
            try {
                super.parse(inputSource);
            }
            finally {
                this.page_.setBuilder(null);
            }
        }
    }
}

