/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 62525 2011-04-15 12:14:31Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.component.html.htmlform;

import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.html.HtmlForm;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;


public final class TestServlet 
    extends com.sun.ts.tests.jsf.api.javax_faces.component.uiform.TestServlet {

    private static final String[] attrNames = {
        "accept", "acceptcharset", "dir", "enctype", "lang", "onclick",
        "ondblclick", "onkeydown", "onkeypress", "onkeyup", "onmousedown",
        "onmousemove", "onmouseout", "onmouseover", "onmouseup",
        "onreset", "onsubmit", "style", "styleClass", "target", "title"
    };

    /**
     * <p>Initializes this {@link javax.servlet.Servlet}.</p>
     * 
     * @param config this Servlet's configuration
     * @throws ServletException if an error occurs
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        setRendererType("javax.faces.Form");
        setAttributeNames(attrNames);
    }


    /**
     * <p>Creates a new {@link UIComponent} instance.</p>
     * 
     * @return a new {@link UIComponent} instance.
     */
    protected UIComponentBase createComponent() {
        HtmlForm form = new HtmlForm();
        form.setSubmitted(true);
        return form;
    }

    protected UIComponent createForm(boolean submitted) {
        HtmlForm form = new HtmlForm();
        form.setSubmitted(submitted);
        return form;
    }

// ------------------------------------------- Test Methods ----

}
