/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 72799 2013-09-04 17:46:14Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.event.abortprocessingexception;

import com.sun.ts.tests.jsf.common.servlets.HttpTCKServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

import javax.faces.event.AbortProcessingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.io.PrintWriter;

public class TestServlet extends HttpTCKServlet {
	
	public void abortProcessingExceptionNoArgCtorTest(
			HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		PrintWriter pw = response.getWriter();

		// No-Arg constructor test
		try {
			throw new AbortProcessingException();

		} catch (AbortProcessingException ape) {
			pw.println(JSFTestUtil.PASS);

		} catch (Exception e) {
			pw.println(JSFTestUtil.FAIL + JSFTestUtil.NL
					+ "Unexpected Exception thrownl");
			e.printStackTrace();
		}
	}
    
    public void abortProcessingExceptionCtor01Test(HttpServletRequest request, 
            HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        
        // constructor that takes a message as an argument test
        String message = "Test Message";
        AbortProcessingException ape = new AbortProcessingException(message);
        
        if (!message.equals(ape.getMessage())){
            pw.println(JSFTestUtil.FAIL + ": AbortProcessingException() did not return the correct " +
            		"message" + JSFTestUtil.NL +
            		"Expected: " + message + JSFTestUtil.NL +
            		"Recieved: " + ape.getMessage());
        } else {
            pw.println(JSFTestUtil.PASS);  
        }

    }
    
    public void abortProcessingExceptionCtor02Test(HttpServletRequest request, 
            HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        
        // constructor that takes Throwable as an argument test
        String message = "Test Message";
        Throwable cause = new Throwable(message);
        AbortProcessingException ape = new AbortProcessingException(cause);
        
        if (!(cause.equals(ape.getCause()))){
            pw.println(JSFTestUtil.FAIL + ": AbortProcessingException() did not return the correct cause");
        } else {
            pw.println(JSFTestUtil.PASS);  
        }

    }
    
    public void abortProcessingExceptionCtor03Test(HttpServletRequest request, 
            HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        
        // constructor that takes Throwable and a message as an argument test
        String message = "Test Message";
        Throwable cause = new Throwable(message);
        AbortProcessingException ape = new AbortProcessingException(message, cause);

        if ((!(message.equals(ape.getMessage()))) && (!(cause.equals(ape.getCause())))){
            
            pw.println(JSFTestUtil.FAIL + ": AbortProcessingException() did not return the " + 
                    "correct cause or message");
        } else {
            pw.println(JSFTestUtil.PASS);  
        }

    }

}
