/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 64095 2011-11-23 14:59:12Z dougd $
 */

/*
 * $Id: TestServlet.java 64095 2011-11-23 14:59:12Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.facesexception;

import com.sun.ts.tests.jsf.common.servlets.HttpTCKServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

import javax.faces.FacesException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.io.PrintWriter;

public class TestServlet extends HttpTCKServlet {

    public void facesExceptionCtor1Test(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        FacesException fe = new FacesException();
        if (fe == null) {
            pw.println("Test FAILED: FacesException() returned null.");
        } else {
            pw.println(JSFTestUtil.PASS);
        }
    }

    public void facesExceptionCtor2Test(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String msg = "This is a test message";
        FacesException fe = new FacesException(msg);
        if (fe != null) {
            if (msg.equals(fe.getMessage().trim())) {
                pw.println(JSFTestUtil.PASS);
            } else {
                pw.println(JSFTestUtil.FAIL + " Exception message was not set" +
                        " properly.");
                pw.println("Expected: " + msg);
                pw.println("Received: " + fe.getMessage());
            }
        } else {
            pw.println("Test FAILED: FacesException(String) returned null.");
        }
    }

    public void facesExceptionCtor3Test(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        ServletException se = new ServletException();

        FacesException fe = new FacesException(se);
        if (fe != null) {
            Throwable t = fe.getCause();
            if (t != null) {
                if (t instanceof ServletException) {
                    pw.println(JSFTestUtil.PASS);
                } else {
                    pw.println(JSFTestUtil.FAIL + " FacesException.getCause() " +
                            "returned " +
                            "unexpected exception type.");
                    pw.println("Excpected: javax.servlet.ServletException");
                    pw.println("Received: " + t.getClass().getName());
                }
            } else {
                pw.println(JSFTestUtil.FAIL + " FacesException.getCause() return " +
                        "null.");
            }
        } else {
            pw.println(JSFTestUtil.FAIL + " FacesException(Throwable) return null.");
        }

    }

    public void facesExceptionCtor4Test(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String msg = "This is a test message";
        ServletException se = new ServletException();
        FacesException fe = new FacesException(msg, se);
        if (fe != null) {
            Throwable t = fe.getCause();
            if (t != null) {
                if (t instanceof ServletException) {
                    if (msg.equals(fe.getMessage().trim())) {
                        pw.println(JSFTestUtil.PASS);
                    } else {
                        pw.println(JSFTestUtil.FAIL + " Exception message was not" +
                                " set properly.");
                        pw.println("Expected: " + msg);
                        pw.println("Received: " + fe.getMessage());
                    }
                } else {
                    pw.println(JSFTestUtil.FAIL + " FacesException.getCause() " +
                            "returned " +
                            "unexpected exception type.");
                    pw.println("Excpected: javax.servlet.ServletException");
                    pw.println("Received: " + t.getClass().getName());
                }
            } else {
                pw.println(JSFTestUtil.FAIL + " FacesException.getCause() return " +
                        "null.");
            }
        } else {
            pw.println(JSFTestUtil.FAIL + " FacesException(Throwable) return null.");
        }
    }

    public void facesExceptionGetCauseTest(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        FacesException fe = new FacesException(new ServletException());
        if (fe != null) {
            Throwable t = fe.getCause();
            if (t != null) {
                if (t instanceof ServletException) {
                    pw.println(JSFTestUtil.PASS);
                } else {
                    pw.println(JSFTestUtil.FAIL + " FacesException.getCause() " +
                            "returned unexepected Exception type.");
                    pw.println("Expected: javax.servlet.ServletException");
                    pw.println("Received: " + t.getClass().getName());
                }
            } else {
                pw.println(JSFTestUtil.FAIL + " FacesException.getCause() returned null.");
            }
        } else {
            pw.println(JSFTestUtil.FAIL + " FacesException(Throwable) return null.");
        }
    }
}
