/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 69931 2013-02-11 21:42:00Z dougd $
 */
package com.sun.ts.tests.jsf.spec.flows.basicmethodcall;

import java.io.PrintWriter;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.sun.javatest.Status;
import com.sun.ts.tests.jsf.common.client.BaseHtmlUnitClient;

public class URLClient extends BaseHtmlUnitClient {

	private static final String CONTEXT_ROOT = "/jsf_flows_basicmethodcall_web";

	public static void main(String[] args) {
		URLClient theTests = new URLClient();
		Status s = theTests.run(args, new PrintWriter(System.out, true),
				new PrintWriter(System.err, true));
		s.exit();
	}

	public Status run(String[] args, PrintWriter out, PrintWriter err) {
		return super.run(args, out, err);
	}

	/*
	 * @class.setup_props: webServerHost; webServerPort; ts_home;
	 */

	/**
	 * @testName: facesFlowBasicMethodCallTest
	 * 
	 * @assertion_ids: PENDING
	 * 
	 * @test_Strategy:
	 * 
	 * @since 2.2
	 */
	public void facesFlowBasicMethodCallTest() throws Fault {

		this.goTest("start_a");
		this.goTest("start_b");

	} // END facesFlowBasicMethodCallTest

	// --------------------------- private methods

	private void goTest(String startId) throws Fault {
		StringBuilder messages = new StringBuilder(128);

		HtmlPage page = getPage(CONTEXT_ROOT + "/faces/index.xhtml");

		doesPageContain(page, "Outside of flow", messages);

		page = doClick((HtmlSubmitInput) page.getElementById(startId));

		page = doClick((HtmlSubmitInput) page
				.getElementById("outcome-from-method"));

		doesPageContain(page, "Last page in the flow", messages);

		page = getPage(CONTEXT_ROOT + "/faces/index.xhtml");

		page = doClick((HtmlSubmitInput) page.getElementById("start_a"));

		page = doClick((HtmlSubmitInput) page
				.getElementById("outcome-from-markup"));

		doesPageContain(page, "voidMethod called in flow-a", messages);

	} // END goTest

} // END URLClient
