/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.defaultmapping.specifictypes.model;

import java.util.Optional;

import com.sun.ts.tests.jsonb.TypeContainer;

public class OptionalTypeContainer implements TypeContainer<Optional<SimpleContainer>> {
    private Optional<SimpleContainer> instance;

    @Override
    public Optional<SimpleContainer> getInstance() {
        return instance;
    }

    @Override
    public void setInstance(Optional<SimpleContainer> instance) {
        this.instance = instance;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof OptionalTypeContainer)) return false;

        OptionalTypeContainer that = (OptionalTypeContainer) o;

        return instance != null ? instance.equals(that.instance) : that.instance == null;
    }

    @Override
    public int hashCode() {
        return instance != null ? instance.hashCode() : 0;
    }
}
