/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: BodyContentFlushTag.java 62554 2011-04-15 18:08:28Z dougd $
 */

package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.bodycontent;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;

import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.JspException;
import java.io.IOException;

public class BodyContentFlushTag extends BodyTagSupport {

    /**
     * Default constructor.
     */
    public BodyContentFlushTag() {
	super();
    }

    /**
     * Validates that an IOException is thrown if BodyContent.flush() is called.
     * 
     * @return SKIP_BODY
     * @throws JspException
     *             - if an error occurs
     */
    public int doAfterBody() throws JspException {
	JspTestUtil.debug("[BodyContentFlushTag] in doAfterBody()");
	BodyContent content = this.getBodyContent();

	try {
	    content.flush();
	} catch (IOException ioe) {
	    try {
		content.getEnclosingWriter().println("Test PASSED");
	    } catch (IOException eio) {
		throw new JspException("Test FAILED. Unexpected IOException!", eio);
	    }
	} catch (Exception e) {
	    throw new JspException("Test FAILED. Unexpected Exception!", e);
	}

	return SKIP_BODY;
    }
}
