/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: DynamicAttributesTag.java 62554 2011-04-15 18:08:28Z dougd $
 */
 
package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.dynamicattributes;

import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.JspException;
import java.io.IOException;

public class DynamicAttributesTag extends TagSupport implements DynamicAttributes {

    boolean _throwException = false;
    boolean _setDynCalled = false;
    /**
     * Default constructor.
     */
    public DynamicAttributesTag() {
        super();
    }

    /**
     * Sets the _throwException instance variable.  If true,
     * when setDynamicAttribute() is called by the container,
     * a JspException will be thrown.
     * @param throwException
     */
    public void setThrowException(boolean throwException) {
        _throwException = throwException;
    }

    /**
     * Validates that setDynamicAttributes is properly called and will cause
     * a test failure if setDynamicAttribute throws a JspException and doStartTag()
     * is called.
     * @return SKIP_BODY
     * @throws JspException if an error occurs
     */
    public int doStartTag() throws JspException {
        try {
            if (!_setDynCalled) {
                pageContext.getOut().println("Test FAILED.  setDynamicAttributes()" +
                    " was not called prior to attempting to invoke doStartTag().");
            }
            if (_throwException) {
                pageContext.getOut().println("Test FAILED.  setDynamicAttributes()" +
                    " threw an Exception but the container incorrectly called doStartTag()");
            }
        } catch (IOException ioe) {
            throw new JspException("Unexpected IOException!", ioe);
        }
        return SKIP_BODY;
    }

    /**
     * Called by the container if a tag has an attribute present and not
     * declared by the TLD.  If _throwException is true, a JspException
     * will be thrown by this method.
     * @param uri - the namespace of the attribute (if any)
     * @param localName - the attribute name
     * @param value - the attribute value
     * @throws JspException if _throwException is true
     */
    public void setDynamicAttribute(
        String uri, String localName, Object value)
        throws JspException {
        _setDynCalled = true;
        if (_throwException) {
            throw new JspException("JspException");
        } else {
            try {
                if ("dynamic".equals(localName)) {
                    if ("dynValue".equals(value)) {
                        pageContext.getOut().println("Test PASSED");
                    } else {
                        pageContext.getOut().println("Test FAILED.  Expected" +
                            " a dynamic attribute value of 'dynValue'.  " +
                            "Received: " + ((String) value));
                    }
                } else {
                    pageContext.getOut().println("Test FAILED.  Expected" +
                        " a dynamic attribute with a local name of 'dynamic'" +
                        ".  Received: " + localName);
                }
            } catch (IOException ioe) {
                throw new JspException("Unexpected IOException!", ioe);
            }
        }
    }
}
