/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SynchronizationTag.java 62554 2011-04-15 18:08:28Z dougd $
 */
 
package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.tagsupport;

import javax.servlet.jsp.JspException;

public class SynchronizationTag extends ContainerInteractionTag {

    /**
     * Default constructor.
     */
    public SynchronizationTag() {
        super();
    }

    /**
     * Adds attributes for begin and nested scripting variables
     * and returns what ever value is configured by the tag.
     * @return an int value based on what the tag is configured to return
     * @throws JspException if an error occurs
     */
    public int doStartTag() throws JspException {
        pageContext.setAttribute("begin", Integer.valueOf(1));
        pageContext.setAttribute("nested", Integer.valueOf(1));
        return super.doStartTag();
    }

    /**
     * Adds attributes for begin and end scripting variables as well as
     * removing nested from the PageContext.
     * @return an int value based on what the tag is configured to return
     * @throws JspException
     */
    public int doEndTag() throws JspException {
        pageContext.setAttribute("begin", Integer.valueOf(getIntValue("begin") + 1));
        pageContext.setAttribute("end", Integer.valueOf(getIntValue("nested") + 1));
        pageContext.removeAttribute("nested");
        return super.doEndTag();
    }

    /**
     * Adds attributes for begin and nested scripting variables.
     * @return an int value based on what the tag is configured to return
     * @throws JspException
     */
    public int doAfterBody() throws JspException {
        pageContext.setAttribute("begin", Integer.valueOf(getIntValue("begin") + 1));
        pageContext.setAttribute("nested", Integer.valueOf(getIntValue("nested") + 1));
        return super.doAfterBody();
    }

}
