/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jsp.spec.core_syntax.directives.page;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;

public class IsELIgnoredFalseActionTag extends SimpleTagSupport {

    private String dollarValue;
    private ValueExpression poundExpr;

    public void setDollarExpr(String dollarExpr) {
        this.dollarValue = dollarExpr;
    }

    public void setPoundExpr(ValueExpression poundExpr) {
        this.poundExpr = poundExpr;
    }

    public void doTag() throws JspException, IOException {
        ELContext elContext = getJspContext().getELContext();
        JspWriter out = getJspContext().getOut();

        try {
            String poundValue = (String) poundExpr.getValue(elContext);
            out.println("Non-deferred value = " + dollarValue);
            out.println("Deferred value = " + poundValue); 
        } catch (Throwable t) {
            JspTestUtil.handleThrowable(t, out, "IsELIgnoredFalseActionTag");
        }
    }
}
