<%--
  Copyright 2003, 2009, 2012, Oracle and its affiliates. All rights reserved.
  ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

  $Id: $
--%>

<%@ page contentType="text/plain" %>
<%@ taglib uri="http://java.sun.com/tck/jsp/el" prefix="el" %>

<jsp:useBean id="type" scope="page"
             class="com.sun.ts.tests.jsp.spec.core_syntax.scripting.el.TypeBean" />

<%-- Validate that if a Boolean or boolean is provided to
     an action that accepts a Character, an error occurs --%>
<% try { %>
<el:checkCoercion control='<%= new Boolean(false) %>' char="${type.booleanPrim}" />
Test FAILED.  Coercion from boolean to Char didn't result in an error.
<% } catch (Throwable t) { } %>

<% try { %>
<el:checkCoercion control='<%= new Boolean(false) %>' char="${type.booleanPrim}" />
Test FAILED.  Coercion from Boolean to Char didn't result in an error.
<% } catch (Throwable t) { } %>

<%-- Validate that if any uncoercable type is provided, an error is raised --%>
<% try { %>
<el:checkCoercion control='<%= new Boolean(false) %>' char="${type}" />
<% } catch (Throwable t) { } %>

<%-- Validate coercion to Character --%>

 <el:checkCoercion name="EmptyStringToChar" control='<%= new Character((char) 0) %>'
                   char="${''}">
  <el:checkCoercion name="CharToChar" control="<%= new Character((char) 31) %>"
                    char="${type.chr}">
   <el:checkCoercion name="ByteToChar" control="<%= new Character((char) 30) %>"
                     char="${type.bite}">
    <el:checkCoercion name="ShortToChar" control="<%= new Character((char) 32) %>"
                    char="${type.shrt}">
     <el:checkCoercion name="IntToChar" control="<%= new Character((char) 33) %>"
                    char="${type.inti}">
      <el:checkCoercion name="LongToChar" control="<%= new Character((char) 34) %>"
                     char="${type.lng}">
       <el:checkCoercion name="FloatToChar" control="<%= new Character((char) 35) %>"
                     char="${type.flote}">
        <el:checkCoercion name="DoubleToChar" control="<%= new Character((char) 36) %>"
                     char="${type.dble}">
         <el:checkCoercion name="StringToChar" control="<%= new Character('s') %>"
                           char="${'strng'}" display="true" />
        </el:checkCoercion>
       </el:checkCoercion>
      </el:checkCoercion>
     </el:checkCoercion>
    </el:checkCoercion>
   </el:checkCoercion>
  </el:checkCoercion>
 </el:checkCoercion>
