/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.spec.pluggability.common;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import java.util.ArrayList;

public final class RequestListener4
        implements ServletRequestListener {

    public void requestDestroyed(ServletRequestEvent event) {
        ArrayList al = null;
        al = (ArrayList) event.getServletContext().getAttribute("testmessage");
        if (al != null) {
            al.add("RequestListener4 requestDestroyed");
            event.getServletContext().setAttribute("testmessage", al);
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
        ArrayList al = null;
        al = (ArrayList) event.getServletContext().getAttribute("testmessage");
        if (al == null) {
            al = new ArrayList();
        }
        al.add("RequestListener4 requestInitialized");
        event.getServletContext().setAttribute("testmessage", al);
    }
}
