/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: GetNegotiatedSubprotocolConfigurator.java 72743 2013-08-28 17:30:13Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.clientendpoint;

import java.util.List;

import javax.websocket.server.ServerEndpointConfig.Configurator;

public class GetNegotiatedSubprotocolConfigurator extends Configurator {
	private static List<String> supported;
	private static List<String> requested;
	private static String resulted;

	@Override
	public String getNegotiatedSubprotocol(List<String> supported,
			List<String> requested) {
		GetNegotiatedSubprotocolConfigurator.setRequested(requested);
		GetNegotiatedSubprotocolConfigurator.setSupported(supported);
		GetNegotiatedSubprotocolConfigurator.setResulted(super
				.getNegotiatedSubprotocol(supported, requested));
		return GetNegotiatedSubprotocolConfigurator.getResulted();
	}

	static List<String> getSupported() {
		return supported;
	}

	static List<String> getRequested() {
		return requested;
	}

	static String getResulted() {
		return resulted;
	}

	private static void setSupported(List<String> supported) {
		GetNegotiatedSubprotocolConfigurator.supported = supported;
	}

	private static void setRequested(List<String> requested) {
		GetNegotiatedSubprotocolConfigurator.requested = requested;
	}

	private static void setResulted(String resulted) {
		GetNegotiatedSubprotocolConfigurator.resulted = resulted;
	}
}
