/*
 * Copyright (c) 2013, 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSByteArrayPartialAndSessionClientEndpoint.java 73423 2014-01-29 15:44:14Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.clientendpointonmessage;

import java.io.IOException;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedStringClientEndpoint;

@ClientEndpoint
public class WSByteArrayPartialAndSessionClientEndpoint extends
		AnnotatedStringClientEndpoint {

	private StringBuffer sb = new StringBuffer();

	@OnMessage
	public void bytesToString(byte[] array, Session s, boolean finito)
			throws IOException {
		sb.append(new String(array)).append("(").append(finito).append(")");
		if (finito) {
			super.onMessage(sb.toString());
			s.getBasicRemote().sendText(
					sb.toString().replaceAll("[(][a-z]*[)]", ""));
			sb = new StringBuffer();
		}
	}

	@OnError
	@Override
	public void onError(Session session, Throwable t) {
		super.onError(session, t);
	}

	@OnClose
	@Override
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@OnOpen
	@Override
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
	}
}
