/*
 * Copyright (c) 2013, 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSStringPartialAndSessionClientEndpoint.java 73423 2014-01-29 15:44:14Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.clientendpointonmessage;

import java.io.IOException;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedStringClientEndpoint;

@ClientEndpoint
public class WSStringPartialAndSessionClientEndpoint extends
		AnnotatedStringClientEndpoint {

	private StringBuilder sb = new StringBuilder();

	@OnMessage
	public void partial(String msg, boolean finito, Session s)
			throws IOException {
		sb.append(msg).append("(").append(finito).append(")");
		if (finito) {
			s.getBasicRemote().sendText(
					sb.toString().replaceAll("[(][a-z]*[)]", ""));
			super.onMessage(sb.toString());
			sb = new StringBuilder();
		}
	}

	@OnError
	@Override
	public void onError(Session session, Throwable t) {
		super.onError(session, t);
	}

	@OnClose
	@Override
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@OnOpen
	@Override
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
	}
}
