/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: InitDestroyTextStreamEncoder.java 71440 2013-04-05 15:03:30Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.coder;

import java.io.IOException;
import java.io.Writer;

import javax.websocket.EncodeException;
import javax.websocket.EndpointConfig;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextStreamEncoder;

public class InitDestroyTextStreamEncoder extends StringBeanTextStreamEncoder {
	@Override
	public void init(EndpointConfig config) {
		Logger.onInit(getClass());
	}

	@Override
	public void destroy() {
		Logger.onDestroy(getClass());
	}
	
	@Override
	public void encode(StringBean bean, Writer writer) throws EncodeException,
			IOException {
		Logger.onCode(getClass());
		super.encode(bean, writer);
	}	
}
