/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCBinaryDecoderServer.java 71484 2013-04-08 16:05:16Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.programaticcoder;

import java.io.IOException;

import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.util.IOUtil;

public class WSCBinaryDecoderServer extends Endpoint implements
		MessageHandler.Whole<StringBean> {

	private Session session;

	@Override
	public void onMessage(StringBean bean) {
		try {
			session.getBasicRemote().sendText(bean.get());
		} catch (IOException e) {
			onError(session, e);
		}
	}

	@Override
	public void onError(Session session, Throwable t) {
		System.out.println("@OnError in" + getClass().getName());
		t.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(t);
		try {
			session.getBasicRemote().sendText(message);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	@Override
	public void onOpen(Session session, EndpointConfig config) {
		this.session = session;
		this.session.addMessageHandler(this);
	}

}
