/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder;

import java.nio.ByteBuffer;

import javax.websocket.Decoder;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;

public abstract class CoderSuperClassBinary<T> extends CoderSuperClass implements Encoder.Binary<T>, Decoder.Binary<T> {

	@Override
	public boolean willDecode(ByteBuffer bytes) {
		return true;
	}

	@Override
	public ByteBuffer encode(T object) throws EncodeException {
		return ByteBuffer.wrap(COMMON_CODED_STRING.getBytes());
	}
	
}
