/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: CaseInsensitiveHeaderNamesConfigurator.java 72308 2013-07-09 10:57:45Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.server.handshakerequest;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import javax.websocket.server.ServerEndpointConfig.Configurator;

public class CaseInsensitiveHeaderNamesConfigurator extends Configurator {

	@Override
	public void modifyHandshake(ServerEndpointConfig sec,
			HandshakeRequest request, HandshakeResponse response) {
		Map<String, List<String>> headers = request.getHeaders();
		boolean isCaseSensitive = true;
		isCaseSensitive &= headers.containsKey(REQUEST_KEY);
		isCaseSensitive &= headers.containsKey(REQUEST_KEY.toLowerCase());
		isCaseSensitive &= headers.containsKey(REQUEST_KEY.toUpperCase());
		response.getHeaders().put(RESPONSE_KEY,
				Arrays.asList(String.valueOf(isCaseSensitive)));
		super.modifyHandshake(sec, request, response);
	}

	/*
	 * Request sets this key with REQUEST_VALUES and case sensitivity is checked
	 * afterwards in modifyHandshake()
	 */
	static final String REQUEST_KEY = "caseInsensitiveKey";

	/*
	 * The value of this key is set to be checked on a client
	 * and the value should reflect boolean value of being case sensitive or not
	 */
	static final String RESPONSE_KEY = "isCaseSensitive";

	static final String[] REQUEST_VALUES = { "RequestValue1", "RequestValue2" };
}
