/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: IsUserInRoleNotAuthenticatedConfigurator.java 72309 2013-07-09 11:33:22Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.server.handshakerequest;

import java.util.Arrays;

import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import javax.websocket.server.ServerEndpointConfig.Configurator;

public class IsUserInRoleNotAuthenticatedConfigurator extends Configurator {
	static final String KEY = "IsUserInRoleNotAuthenticatedConfigurator";

	@Override
	public void modifyHandshake(ServerEndpointConfig sec,
			HandshakeRequest request, HandshakeResponse response) {
		boolean isInRole = request.isUserInRole("j2ee");
		isInRole |= request.isUserInRole("DIRECTOR");
		String value = String.valueOf(isInRole);
		response.getHeaders().put(KEY, Arrays.asList(value));
	}
}
