/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCountConfiguratorInstancesSecondServer.java 71236 2013-03-29 12:29:59Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.server.serverendpoint;

import java.lang.annotation.Annotation;

import javax.websocket.OnMessage;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig.Configurator;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint(value = "/counttwo", configurator = CountingConfigurator.class)
public class WSCountConfiguratorInstancesSecondServer {

	@OnMessage
	public String getCountingConfiguratorValue(String op) {
		Annotation ann = getClass().getAnnotations()[0];
		ServerEndpoint endpoint = (ServerEndpoint) ann;
		Class<? extends Configurator> config = endpoint.configurator();
		try {
			CountingConfigurator cc = (CountingConfigurator) config
					.getConstructor(boolean.class).newInstance(true);
			String ret = String.valueOf(cc.getCounterValue());
			return ret;
		} catch (Exception e) {
			return IOUtil.printStackTrace(e);
		}
	}
}
