/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ByteBufferMessageHandler.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.client;

import java.nio.ByteBuffer;

import javax.websocket.MessageHandler;

import com.sun.ts.tests.websocket.common.util.IOUtil;

public class ByteBufferMessageHandler implements
		MessageHandler.Whole<ByteBuffer> {

	MixedProgramaticEndpoint endpoint;
	public static final String HANDLER_SAYS = "ByteBufferMessageHandler says: ";

	public ByteBufferMessageHandler(MixedProgramaticEndpoint endpoint) {
		super();
		this.endpoint = endpoint;
	}

	@Override
	public void onMessage(ByteBuffer message) {
		endpoint.onMessage(HANDLER_SAYS + IOUtil.byteBufferToString(message));
	}
}
