/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$
 */

package com.sun.ts.tests.websocket.negdep.onclose.srv.duplicate;

import java.io.IOException;

import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint("/invalid")
public class OnCloseServerEndpoint {
	private static String close = "";

	@OnMessage
	public String echo(String echo) {
		return echo + close;
	}

	@OnClose
	public void onClose(Session session) {
		close = "first @OnClose";
	}
	
	@OnClose
	public void onClose(Session session, CloseReason reason) {
		close = "second @OnClose";
	}
	

	@OnError
	public void onError(Session session, Throwable thr) throws IOException {
		thr.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(thr);
		session.getBasicRemote().sendText(message);
	}
}
