/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.server.handshakerequest;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.ClientConfigurator;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.StringUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.handshakerequest.CaseInsensitiveHeaderNamesConfigurator;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.HandshakeResponse;
import java.util.Collection;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSCClientIT
extends WebSocketCommonClient {
    static final String KEY = "aFirstKey";
    static final String[] HEADERS = new String[]{"header1", "header2", "header3", "header4", "header5", "header6", "header7", "header8"};

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_jakarta_websocket_handshakerequest_web.war");
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{WSCClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.server.handshakerequest"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSCClientIT() throws Exception {
        this.setContextRoot("wsc_ee_jakarta_websocket_handshakerequest_web");
    }

    @Test
    public void getHeadersIsReadonlyTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator(){

            public void afterResponse(HandshakeResponse hr) {
                super.afterResponse(hr);
                boolean contains = hr.getHeaders().containsKey("GetQueryStringConfigurator");
                1.assertTrue((!contains ? 1 : 0) != 0, (String[])new String[]{"HandshakeRequest.getHeaders is not readonly, it contains [", "GetQueryStringConfigurator", ",", StringUtil.collectionToString((Collection)((Collection)hr.getHeaders().get("GetQueryStringConfigurator"))), "]"});
                WebSocketCommonClient.logMsg((Object[])new Object[]{"HandshakeRequest.getHeaders is readonly as expected"});
            }
        };
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("readonlygetheaders", "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getHeadersHasCaseInsensitiveNamesTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToRequest("caseInsensitiveKey", CaseInsensitiveHeaderNamesConfigurator.REQUEST_VALUES);
        configurator.addToResponse("isCaseSensitive", new String[]{String.valueOf(true)});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("caseinsensitiveheadernames", "anything", new String[]{"anything"});
        configurator.assertBeforeRequestHasBeenCalled();
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getParameterMapIsUnmodifiableTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator(){

            public void afterResponse(HandshakeResponse hr) {
                super.afterResponse(hr);
                boolean contains = hr.getHeaders().containsKey("ReadOnlyKey");
                2.assertTrue((!contains ? 1 : 0) != 0, (String[])new String[]{"HandshakeRequest.getParameterMap is not readonly, it contains [", "ReadOnlyKey", ",", StringUtil.collectionToString((Collection)((Collection)hr.getHeaders().get("ReadOnlyKey"))), "]"});
                WebSocketCommonClient.logMsg((Object[])new Object[]{"HandshakeRequest.getParameterMap is readonly as expected"});
            }
        };
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("readonlygetparams", "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getParameterMapOneParamTest() throws Exception {
        String param = "firstParam";
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("first", new String[]{param});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, param);
        this.invoke("getoneparam/" + param, "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getParameterMapOneParamOneQueryParamTest() throws Exception {
        String param = "firstParam";
        String queryParam = "secondParam";
        String query = "?second=" + queryParam + "&second=" + param;
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("second", new String[]{queryParam, param});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, param);
        this.invoke("getoneparam/" + param + query, "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getParameterMapTwoParamsTest() throws Exception {
        String[] params = new String[]{String.valueOf(123L), String.valueOf(123.456)};
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("first", new String[]{params[0]});
        configurator.addToResponse("second", new String[]{params[1]});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, params[0]);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, params[1]);
        this.invoke("gettwoparams/" + params[0] + "/" + params[1], "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getQueryStringTest() throws Exception {
        String query = "abc=123&def=456";
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("GetQueryStringConfigurator", new String[]{query});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("getquerystring?" + query, "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getRequestUriTest() throws Exception {
        String uri = "getrequesturi";
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("GetRequestUriConfigurator", new String[]{uri});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke(uri, "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getUserPrincipalNotAuthenticatedTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("GetUserPrincipalNotAuthenticatedConfigurator", new String[]{String.valueOf(true)});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("getuserprincipal", "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void isUserInRoleNotAuthenticatedTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("IsUserInRoleNotAuthenticatedConfigurator", new String[]{String.valueOf(false)});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("isuserinrole", "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getUserX509CertificateChainNotAuthenticatedTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("GetUserX509CertificateChainNotAuthenticatedConfigurator", new String[]{String.valueOf(true)});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("getuserx509certificatechain", "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getLocalAddressTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("GetLocalAddressConfigurator", new String[]{String.valueOf(true)});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("getlocaladdress", "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getLocalHostNameTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("GetLocalHostHameConfigurator", new String[]{String.valueOf(true)});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("getlocalhostname", "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getLocalPortTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("GetLocalPortConfigurator", new String[]{String.valueOf(true)});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("getlocalport", "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getRemoteAddressTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("GetRemoteAddressConfigurator", new String[]{String.valueOf(true)});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("getremoteaddress", "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getRemoteHostNameTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("GetRemoteHostHameConfigurator", new String[]{String.valueOf(true)});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("getremotehostname", "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getRemotePortTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("GetRemotePortConfigurator", new String[]{String.valueOf(true)});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("getremoteport", "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getLocaleNoHeaderTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse("GetLocaleNoHeaderConfigurator", new String[]{String.valueOf(true)});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("getlocalenoheader", "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getLocaleFrenchTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToRequest("Accept-Language", new String[]{"fr"});
        configurator.addToResponse("GetLocaleFrenchConfigurator", new String[]{String.valueOf(true)});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("getlocalefrench", "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void getLocaleGermanTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToRequest("Accept-Language", new String[]{"de"});
        configurator.addToResponse("GetLocaleGermanConfigurator", new String[]{String.valueOf(true)});
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("getlocalegerman", "anything", new String[]{"anything"});
        configurator.assertAfterResponseHasBeenCalled();
    }
}

