/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.Collection;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ui.workbench.renderers.base.BaseItemRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.Util;
import org.eclipse.jdt.annotation.NonNull;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EventProcessor {
    public static <C extends MUIElement, M extends MElementContainer<C>, R extends BaseRenderer<M, ?>> void attachChildProcessor(IEventBroker eventBroker, final R renderer) {
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", new EventHandler(){

            public void handleEvent(Event event) {
                Object changedObj = event.getProperty("ChangedElement");
                MUIElement parent = (MUIElement)changedObj;
                if (parent.getRenderer() == renderer) {
                    if (UIEvents.isADD((Event)event)) {
                        ((ChildrenHandler)((Object)renderer)).handleChildrenAddition((MElementContainer)parent, Util.asCollection(event, "NewValue"));
                    } else if (UIEvents.isREMOVE((Event)event)) {
                        ((ChildrenHandler)((Object)renderer)).handleChildrenRemove((MElementContainer)parent, Util.asCollection(event, "OldValue"));
                    }
                }
            }
        });
    }

    public static <M extends MUIElement, R extends BaseRenderer<M, ?>> void attachVisibleProcessor(IEventBroker eventBroker, final R renderer) {
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/visible/*", new EventHandler(){

            public void handleEvent(Event event) {
                String eventType;
                EObject parent;
                MUIElement changedObj = (MUIElement)event.getProperty("ChangedElement");
                if (changedObj.isToBeRendered() && (parent = ((EObject)changedObj).eContainer()) instanceof MUIElement && ((MUIElement)parent).getRenderer() == renderer && "SET".equals(eventType = (String)event.getProperty("EventType"))) {
                    boolean newVisibility;
                    Boolean current = (Boolean)changedObj.getTransientData().get("efx_calculated_visibility");
                    boolean visibleWhen = BaseRenderer.checkVisibleWhen(changedObj, renderer.getModelContext(changedObj));
                    if (current == null) {
                        current = !changedObj.isVisible() && visibleWhen;
                    }
                    boolean bl = newVisibility = changedObj.isVisible() && visibleWhen;
                    if (current != newVisibility) {
                        changedObj.getTransientData().put("efx_calculated_visibility", newVisibility);
                        if (newVisibility) {
                            renderer.showChild((MUIElement)parent, changedObj);
                        } else {
                            renderer.hideChild((MUIElement)parent, changedObj);
                        }
                    }
                }
            }
        });
        eventBroker.subscribe("org/eclipse/fx/MUIElement/UpdateVisibleWhenResult", new EventHandler(){

            public void handleEvent(Event event) {
                EObject parent;
                MUIElement element = (MUIElement)event.getProperty("org.eclipse.e4.data");
                if (element.isToBeRendered() && (parent = ((EObject)element).eContainer()) instanceof MUIElement && ((MUIElement)parent).getRenderer() == renderer) {
                    boolean newVisibility;
                    Boolean current = (Boolean)element.getTransientData().get("efx_calculated_visibility");
                    boolean visibleWhen = BaseRenderer.checkVisibleWhen(element, renderer.getModelContext(element));
                    if (current == null) {
                        current = element.isVisible();
                    }
                    if (element.getTags().contains("hideOnDisable") && element instanceof MItem) {
                        MItem i = (MItem)element;
                        Object renderer2 = element.getRenderer();
                        if (renderer2 instanceof BaseItemRenderer) {
                            visibleWhen = visibleWhen && i.isEnabled() && ((BaseItemRenderer)renderer2).canExecute(element, ((BaseItemRenderer)renderer2).getModelContext(element));
                        }
                    }
                    boolean bl = newVisibility = element.isVisible() && visibleWhen;
                    if (current != newVisibility) {
                        element.getTransientData().put("efx_calculated_visibility", newVisibility);
                        if (newVisibility) {
                            renderer.childRendered((MUIElement)parent, element);
                        } else {
                            renderer.hideChild((MUIElement)parent, element);
                        }
                    }
                }
            }
        });
    }

    public static interface ChildrenHandler<M extends MUIElement, C extends MUIElement> {
        public void handleChildrenAddition(@NonNull M var1, @NonNull Collection<@NonNull C> var2);

        public void handleChildrenRemove(@NonNull M var1, @NonNull Collection<@NonNull C> var2);
    }
}

