/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core;

import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.GerritRepository;
import org.eclipse.egerrit.internal.core.Gerrit_2_11;
import org.eclipse.egerrit.internal.core.Gerrit_2_9;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.osgi.framework.Version;

public final class GerritFactory {
    public static final Version MINIMAL_VERSION = new Version(2, 9, 0);

    public static GerritClient create(GerritRepository gerritRepository) throws EGerritException {
        if (gerritRepository == null) {
            throw new EGerritException("Invalid gerrit repository");
        }
        gerritRepository.connect();
        Version version = gerritRepository.getVersion();
        if (version == null) {
            return null;
        }
        if (version.compareTo(MINIMAL_VERSION) < 0) {
            throw new EGerritException("Unsupported gerrit version (< " + MINIMAL_VERSION.toString() + ")");
        }
        GerritClient gerrit = null;
        Version workVersion = new Version(version.getMajor(), version.getMinor(), version.getMicro(), version.getQualifier());
        do {
            switch (workVersion.toString()) {
                case "2.9.0": {
                    gerrit = new Gerrit_2_9(gerritRepository);
                    break;
                }
                case "2.11.0": {
                    gerrit = new Gerrit_2_11(gerritRepository);
                    break;
                }
                default: {
                    workVersion = workVersion.getQualifier() != "" ? new Version(version.getMajor(), version.getMinor(), version.getMicro(), null) : (workVersion.getMicro() > 0 ? new Version(version.getMajor(), version.getMinor(), workVersion.getMicro() - 1) : (workVersion.getMinor() > 0 ? new Version(version.getMajor(), workVersion.getMinor() - 1, 0) : (workVersion.getMajor() > MINIMAL_VERSION.getMajor() ? new Version(workVersion.getMajor() - 1, 0, 0) : MINIMAL_VERSION)));
                }
            }
        } while (gerrit == null);
        return gerrit;
    }

    private GerritFactory() {
    }
}

