/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritCredentials;
import org.eclipse.egerrit.internal.core.GerritRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritHttpClient
implements IProxyChangeListener {
    private static Logger logger = LoggerFactory.getLogger(GerritHttpClient.class);
    private GerritRepository fRepository;
    private CloseableHttpClient fHttpClient = null;
    private GerritCredentials fCredentials = null;
    private CredentialsProvider fCredentialsProvider = new BasicCredentialsProvider();
    private CookieStore fCookieStore = new BasicCookieStore();
    private X509HostnameVerifier fHostNameVerifier = new AllowAllHostnameVerifier();
    private int fStatus;
    private static final String ACCOUNTS_SELF_REQUEST = "/accounts/self";
    private static final String ACCEPT_TAG = "Accept";
    private static final String JSON_TAG = "application/json";
    private static final String X_GERRIT_AUTHORITY_TAG = "X-Gerrit-Auth";
    private static final String LOGIN_REQUEST = "/login/mine";
    private static final String LOGIN_COOKIE_NAME = "GerritAccount";
    private volatile Cookie fAuthCookie;
    private volatile String fCookiePath;
    private final String GERRIT_KEY_TAG = "gerrit_hostpagedata.xGerritAuth=";
    private volatile String fKey;
    private volatile boolean gotKey;

    private GerritHttpClient() {
    }

    public GerritHttpClient(GerritRepository repository, GerritCredentials creds) {
        this.fRepository = repository;
        this.createHttpClient(creds);
        this.watchProxyChange();
    }

    private void watchProxyChange() {
        EGerritCorePlugin.getDefault().getProxyService().addProxyChangeListener((IProxyChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHttpClient(GerritCredentials creds) {
        try {
            HttpClientBuilder builder = HttpClients.custom().setDefaultCookieStore(this.fCookieStore).setHostnameVerifier(this.fHostNameVerifier).setUserAgent(EGerritCorePlugin.getDefault().getUserAgent());
            HttpHost proxy = this.fRepository.getProxy();
            if (proxy != null) {
                builder.setProxy(proxy);
            } else {
                HttpHost proxyHost = EGerritCorePlugin.getDefault().getProxyForHost(this.fRepository.getHostname());
                if (proxyHost != null) {
                    builder.setProxy(proxyHost);
                }
            }
            SSLContextBuilder sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext.build());
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
            if (creds != null && creds.getUsername() != null && !creds.getUsername().isEmpty()) {
                this.fCredentials = creds;
                AuthScope scope = new AuthScope(this.fRepository.getHost());
                this.fCredentialsProvider.setCredentials(scope, this.fCredentials.getGerritCredentials());
                builder.setDefaultCredentialsProvider(this.fCredentialsProvider);
            }
            CloseableHttpClient newlyCreatedClient = builder.build();
            GerritHttpClient gerritHttpClient = this;
            synchronized (gerritHttpClient) {
                this.fHttpClient = newlyCreatedClient;
            }
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        GerritHttpClient gerritHttpClient = this;
        synchronized (gerritHttpClient) {
            return this.fHttpClient.execute(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        GerritHttpClient gerritHttpClient = this;
        synchronized (gerritHttpClient) {
            if (this.gotKey) {
                request.addHeader(X_GERRIT_AUTHORITY_TAG, this.fKey);
            }
            return (T)this.fHttpClient.execute(request, responseHandler);
        }
    }

    public CookieStore getCookieStore() {
        return this.fCookieStore;
    }

    public boolean authenticate() {
        if (this.fCredentials == null) {
            return true;
        }
        if (this.fCredentials.isOpenIdAuthenticated()) {
            String openIdProvider = this.fCredentials.getOpenIdProvider();
            Credentials creds = this.fCredentials.getCredentials();
            return this.openIdAuthentication(openIdProvider, creds);
        }
        if (this.fCredentials.isHttpAuthenticated()) {
            Credentials creds = this.fCredentials.getHttpCredentials();
            return this.httpAuthentication(creds);
        }
        Credentials creds = this.fCredentials.getCredentials();
        if (creds != null) {
            if (this.userPasswordAuthentication(creds, false)) {
                return true;
            }
            return this.userPasswordAuthentication(creds, true);
        }
        return false;
    }

    private boolean testAuthentication() {
        int status = 0;
        try {
            URIBuilder builder = this.fRepository.getURIBuilder(false);
            String path = builder.getPath() + ACCOUNTS_SELF_REQUEST;
            URI uri = builder.setPath(path).build();
            HttpGet request = new HttpGet(uri);
            request.addHeader(ACCEPT_TAG, JSON_TAG);
            if (this.gotKey) {
                request.addHeader(X_GERRIT_AUTHORITY_TAG, this.fKey);
            }
            logger.debug("Request: " + uri.toString());
            HttpResponse response = this.execute((HttpUriRequest)request);
            StatusLine statusLine = response.getStatusLine();
            logger.debug("Result : " + statusLine.toString());
            status = statusLine.getStatusCode();
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (ClientProtocolException e) {
            EGerritCorePlugin.logError(e.getLocalizedMessage());
        }
        catch (IOException e) {
            EGerritCorePlugin.logError(e.getLocalizedMessage());
        }
        catch (URISyntaxException e) {
            EGerritCorePlugin.logError(e.getLocalizedMessage());
        }
        return status == 200;
    }

    private boolean openIdAuthentication(String provider, Credentials creds) {
        return false;
    }

    private boolean httpAuthentication(Credentials creds) {
        return creds != null && creds.getUserPrincipal() != null;
    }

    private boolean userPasswordAuthentication(Credentials creds, boolean userBecomesAnyAccount) {
        this.fStatus = 0;
        try {
            URIBuilder builder = this.fRepository.getURIBuilder(false);
            String path = builder.getPath() + LOGIN_REQUEST;
            URI uri = builder.setPath(path).build();
            HttpPost request = new HttpPost(uri);
            List<NameValuePair> authParams = this.getAuthParams(userBecomesAnyAccount);
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(authParams, Consts.UTF_8));
            logger.debug("Request: " + uri.toString());
            HttpResponse response = this.execute((HttpUriRequest)request);
            StatusLine statusLine = response.getStatusLine();
            logger.debug("Result : " + statusLine.toString());
            this.fStatus = statusLine.getStatusCode();
            EntityUtils.consume((HttpEntity)response.getEntity());
            if (this.fStatus == 302) {
                this.extractGerritCookie();
                this.fStatus = this.getGerritAuthKey();
            }
            if (this.fStatus == 200) {
                return this.testAuthentication();
            }
        }
        catch (ClientProtocolException e) {
            EGerritCorePlugin.logError(e.getLocalizedMessage());
        }
        catch (IOException e) {
            EGerritCorePlugin.logError(e.getLocalizedMessage());
        }
        catch (URISyntaxException e) {
            EGerritCorePlugin.logError(e.getLocalizedMessage());
        }
        return this.fStatus == 200;
    }

    private List<NameValuePair> getAuthParams(boolean dev) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        String userName = this.fCredentials.getUsername();
        if (dev) {
            String field = "user_name";
            if (userName.contains("@")) {
                field = "preferred_email";
            } else {
                try {
                    Integer.decode(userName);
                    field = "account_id";
                }
                catch (NumberFormatException numberFormatException) {}
            }
            params.add((NameValuePair)new BasicNameValuePair(field, userName));
        } else {
            params.add((NameValuePair)new BasicNameValuePair("username", userName));
            params.add((NameValuePair)new BasicNameValuePair("password", this.fCredentials.getPassword()));
        }
        return params;
    }

    private void extractGerritCookie() {
        CookieStore cookies = this.getCookieStore();
        for (Cookie cookie : cookies.getCookies()) {
            if (!LOGIN_COOKIE_NAME.equals(cookie.getName())) continue;
            this.setGerritAuthCookie(cookie);
        }
    }

    private synchronized void setGerritAuthCookie(Cookie cookie) {
        Cookie oldCookie = this.fAuthCookie;
        this.fAuthCookie = cookie;
        if (this.fAuthCookie != null) {
            this.fCookiePath = cookie.getPath();
            if (!this.fAuthCookie.equals(oldCookie)) {
                this.getCookieStore().addCookie(this.fAuthCookie);
            }
        } else {
            this.gotKey = false;
        }
    }

    private int getGerritAuthKey() {
        int status = 0;
        try {
            URIBuilder builder = this.fRepository.getURIBuilder(false);
            URI uri = builder.setPath(this.fCookiePath).build();
            HttpGet request = new HttpGet(uri);
            logger.debug("Request: " + uri.toString());
            HttpResponse response = this.execute((HttpUriRequest)request);
            StatusLine statusLine = response.getStatusLine();
            logger.debug("Result : " + statusLine.toString());
            status = statusLine.getStatusCode();
            if (status == 200) {
                this.extractGerritAuthKey(response);
            }
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (ClientProtocolException e) {
            EGerritCorePlugin.logError(e.getLocalizedMessage());
        }
        catch (IOException e) {
            EGerritCorePlugin.logError(e.getLocalizedMessage());
        }
        catch (URISyntaxException e) {
            EGerritCorePlugin.logError(e.getLocalizedMessage());
        }
        return status;
    }

    private void extractGerritAuthKey(HttpResponse response) {
        this.gotKey = false;
        this.getAuthKeyForGerrit212(response);
        if (this.gotKey) {
            return;
        }
        this.getAuthKeyPreviousTo212(response);
    }

    private void getAuthKeyPreviousTo212(HttpResponse response) {
        try {
            String contents = EntityUtils.toString((HttpEntity)response.getEntity());
            int loc = contents.indexOf("gerrit_hostpagedata.xGerritAuth=");
            if (loc >= 0) {
                int beginIndex = loc + "gerrit_hostpagedata.xGerritAuth=".length() + 1;
                int endIndex = contents.indexOf(34, beginIndex);
                this.fKey = contents.substring(beginIndex, endIndex);
                this.gotKey = true;
            }
        }
        catch (IOException e) {
            logger.debug("Problem reading auth key ", (Throwable)e);
        }
    }

    private void getAuthKeyForGerrit212(HttpResponse response) {
        this.gotKey = false;
        Header header = response.getFirstHeader("Set-Cookie");
        if (header != null) {
            HeaderElement[] elements;
            HeaderElement[] headerElementArray = elements = header.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                HeaderElement headerElement = headerElementArray[n2];
                if (headerElement.getName().equals("XSRF_TOKEN")) {
                    this.fKey = headerElement.getValue();
                    this.gotKey = true;
                }
                ++n2;
            }
        }
    }

    public int getStatus() {
        return this.fStatus;
    }

    public void proxyInfoChanged(IProxyChangeEvent event) {
        this.createHttpClient(this.fCredentials);
    }

    protected void finalize() throws Throwable {
        EGerritCorePlugin.getDefault().getProxyService().removeProxyChangeListener((IProxyChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        GerritHttpClient gerritHttpClient = this;
        synchronized (gerritHttpClient) {
            if (this.fHttpClient != null) {
                try {
                    this.fHttpClient.close();
                }
                catch (IOException e) {
                    logger.debug("An exception occured closing the connection to the gerrit server", (Throwable)e);
                }
            }
        }
    }
}

