/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.egerrit.internal.ui.compare.GerritCommentAnnotation;
import org.eclipse.egerrit.internal.ui.compare.PatchSetCompareItem;
import org.eclipse.egerrit.internal.ui.compare.UICompareUtils;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class NextPreviousCommentAnnotationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent aEvent) {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)aEvent);
        CompareEditorInput editPart = (CompareEditorInput)activeEditor.getEditorInput();
        MergeSourceViewer mergeSourceViewer = UICompareUtils.extractMergeSourceViewer(editPart.getNavigator(), false);
        if (mergeSourceViewer != null) {
            SourceViewer sourceViewer = mergeSourceViewer.getSourceViewer();
            String commandName = aEvent.getCommand().getId();
            boolean isNext = commandName.contains("NextCommentAnnotationHandler");
            Position requestedCommentPosition = null;
            Point curPos = sourceViewer.getSelectedRange();
            PatchSetCompareItem patchSetCompareItem = (PatchSetCompareItem)sourceViewer.getDocument();
            TreeMap<Integer, GerritCommentAnnotation> sortedCommentMap = this.getSortedGerritAnnotation(patchSetCompareItem);
            requestedCommentPosition = isNext ? this.findNextGerritCommentPosition(sortedCommentMap, curPos, patchSetCompareItem) : this.findPreviousGerritCommentPosition(sortedCommentMap, curPos, patchSetCompareItem);
            if (requestedCommentPosition != null) {
                int offset = requestedCommentPosition.getOffset();
                int length = requestedCommentPosition.getLength();
                sourceViewer.setSelection((ISelection)new TextSelection(offset, length), true);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    private Position findNextGerritCommentPosition(TreeMap<Integer, GerritCommentAnnotation> sortedCommentMap, Point curPos, PatchSetCompareItem patchSetCompareItem) {
        Map.Entry<Integer, GerritCommentAnnotation> entryMap = sortedCommentMap.higherEntry(curPos.x);
        if (entryMap != null) {
            return this.setPosition(entryMap);
        }
        return this.getFirstCommentPosition(sortedCommentMap);
    }

    private Position findPreviousGerritCommentPosition(TreeMap<Integer, GerritCommentAnnotation> sortedCommentMap, Point curPos, PatchSetCompareItem patchSetCompareItem) {
        Map.Entry<Integer, GerritCommentAnnotation> entryMap = sortedCommentMap.lowerEntry(curPos.x);
        if (entryMap != null) {
            return this.setPosition(entryMap);
        }
        return this.getLastCommentPosition(sortedCommentMap);
    }

    private Position setPosition(Map.Entry<Integer, GerritCommentAnnotation> entryMap) {
        if (entryMap != null) {
            Position position = new Position(0, 0);
            position.setOffset(entryMap.getKey().intValue());
            position.setLength(entryMap.getValue().getText().length());
            return position;
        }
        return null;
    }

    private TreeMap<Integer, GerritCommentAnnotation> getSortedGerritAnnotation(PatchSetCompareItem patchSetCompareItem) {
        TreeMap<Integer, GerritCommentAnnotation> adjustedMap = new TreeMap<Integer, GerritCommentAnnotation>();
        Iterator it = patchSetCompareItem.getEditableComments().getAnnotationIterator();
        while (it.hasNext()) {
            GerritCommentAnnotation annotation = (GerritCommentAnnotation)((Object)it.next());
            Position position = patchSetCompareItem.getEditableComments().getPosition((Annotation)annotation);
            adjustedMap.put(position.offset, annotation);
        }
        return this.getGroupCommentAnnotation(adjustedMap);
    }

    private TreeMap<Integer, GerritCommentAnnotation> getGroupCommentAnnotation(TreeMap<Integer, GerritCommentAnnotation> initSortedMap) {
        int lastLine = -1;
        TreeMap<Integer, GerritCommentAnnotation> groupMap = new TreeMap<Integer, GerritCommentAnnotation>();
        for (Map.Entry<Integer, GerritCommentAnnotation> entry : initSortedMap.entrySet()) {
            GerritCommentAnnotation annotation = entry.getValue();
            int currentLine = annotation.getComment().getLine();
            if (currentLine == lastLine) continue;
            lastLine = currentLine;
            groupMap.put(entry.getKey(), annotation);
        }
        return groupMap;
    }

    private Position getFirstCommentPosition(TreeMap<Integer, GerritCommentAnnotation> sortedCommentMap) {
        Position position = null;
        if (!sortedCommentMap.isEmpty()) {
            int offset = sortedCommentMap.firstKey();
            int length = sortedCommentMap.firstEntry().getValue().getText().length();
            position = new Position(offset, length);
        }
        return position;
    }

    private Position getLastCommentPosition(TreeMap<Integer, GerritCommentAnnotation> sortedCommentMap) {
        Position position = null;
        if (!sortedCommentMap.isEmpty()) {
            int offset = sortedCommentMap.lastKey();
            int length = sortedCommentMap.lastEntry().getValue().getText().length();
            position = new Position(offset, length);
        }
        return position;
    }
}

