/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core.command;

import java.lang.reflect.Type;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.eclipse.egerrit.internal.core.GerritRepository;
import org.eclipse.egerrit.internal.core.command.AuthentificationRequired;
import org.eclipse.egerrit.internal.core.command.BaseCommandChangeAndRevisionAndFile;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.model.FileInfo;

public class SetReviewedCommand
extends BaseCommandChangeAndRevisionAndFile<String> {
    private FileInfo fileInfo;

    public SetReviewedCommand(GerritRepository gerritRepository, String changeId, String revisionId, FileInfo fileInfo) {
        super(gerritRepository, AuthentificationRequired.YES, (Class<? extends HttpRequestBase>)HttpPut.class, (Type)((Object)String.class), changeId, revisionId, fileInfo.getPath());
        this.fileInfo = fileInfo;
        this.setPathFormat("/changes/{change-id}/revisions/{revision-id}/files/{file-id}/reviewed");
    }

    @Override
    protected boolean expectsJson() {
        return false;
    }

    @Override
    public String call() throws EGerritException {
        boolean reviewed = this.fileInfo.isReviewed();
        try {
            this.fileInfo.setReviewed(true);
            return (String)super.call();
        }
        catch (EGerritException e) {
            this.fileInfo.setReviewed(reviewed);
            throw e;
        }
    }
}

