/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritServerInformation;
import org.osgi.service.prefs.BackingStoreException;

public class ServersStore {
    private static final String EGERRIT_NODE = "org.eclipse.egerrit.core";
    private static final String KEY_SERVERS_LIST = "serversList";
    private static int timestamp = 0;

    private ServersStore() {
    }

    public static void saveServers(List<GerritServerInformation> servers) {
        ++timestamp;
        String serializedServers = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create().toJson(servers);
        InstanceScope.INSTANCE.getNode(EGERRIT_NODE).put(KEY_SERVERS_LIST, serializedServers);
        try {
            InstanceScope.INSTANCE.getNode(EGERRIT_NODE).flush();
        }
        catch (BackingStoreException e) {
            EGerritCorePlugin.logError(e.getLocalizedMessage());
        }
        for (GerritServerInformation server : servers) {
            server.persistPassword();
        }
    }

    public static List<GerritServerInformation> getAllServers() {
        String serverList = InstanceScope.INSTANCE.getNode(EGERRIT_NODE).get(KEY_SERVERS_LIST, "");
        if (serverList.isEmpty()) {
            return new ArrayList<GerritServerInformation>();
        }
        return (List)new Gson().fromJson(serverList, new TypeToken<ArrayList<GerritServerInformation>>(){}.getType());
    }

    public static GerritServerInformation getServer(String identifier) {
        if (identifier == null) {
            return null;
        }
        int id = -1;
        try {
            id = Integer.parseInt(identifier);
        }
        catch (NumberFormatException e) {
            return null;
        }
        List<GerritServerInformation> servers = ServersStore.getAllServers();
        for (GerritServerInformation server : servers) {
            if (server.hashCode() != id) continue;
            return server;
        }
        return null;
    }

    public static int getStoreTimeStamp() {
        return timestamp;
    }
}

