/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.ProjectReference;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.op.BranchOperation;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.settings.GitSettings;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;

public class ProjectReferenceImporter {
    private final String[] referenceStrings;

    public ProjectReferenceImporter(String[] referenceStrings) {
        this.referenceStrings = referenceStrings;
    }

    public List<IProject> run(IProgressMonitor monitor) throws TeamException {
        Map<URIish, Map<String, Set<ProjectReference>>> repositories = this.parseReferenceStrings();
        ArrayList<IProject> importedProjects = new ArrayList<IProject>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)repositories.size());
        for (Map.Entry<URIish, Map<String, Set<ProjectReference>>> entry : repositories.entrySet()) {
            URIish gitUrl = entry.getKey();
            Map<String, Set<ProjectReference>> refs = entry.getValue();
            SubMonitor subProgress = progress.newChild(1).setWorkRemaining(refs.size());
            for (Map.Entry<String, Set<ProjectReference>> refEntry : refs.entrySet()) {
                String refName = refEntry.getKey();
                Set<ProjectReference> projects = refEntry.getValue();
                Set<String> allRefs = refs.keySet();
                File repositoryPath = null;
                if (allRefs.size() == 1) {
                    repositoryPath = ProjectReferenceImporter.findConfiguredRepository(gitUrl);
                }
                SubMonitor subSubProgress = subProgress.newChild(1).setWorkRemaining(repositoryPath == null ? 2 : 1);
                if (repositoryPath == null) {
                    try {
                        IPath workDir = ProjectReferenceImporter.getWorkingDir(gitUrl, refName, refs.keySet());
                        repositoryPath = ProjectReferenceImporter.cloneIfNecessary(gitUrl, refName, workDir, projects, (IProgressMonitor)subSubProgress.newChild(1));
                    }
                    catch (InterruptedException e) {
                        return Collections.emptyList();
                    }
                }
                RepositoryUtil.INSTANCE.addConfiguredRepository(repositoryPath);
                for (ProjectReference projectReference : projects) {
                    ProjectReferenceImporter.checkoutBranchIfNecessary(projectReference, monitor);
                }
                IPath newWorkDir = new Path(repositoryPath.getAbsolutePath()).removeLastSegments(1);
                List<IProject> p = this.importProjects(projects, newWorkDir, repositoryPath, (IProgressMonitor)subSubProgress.newChild(1));
                importedProjects.addAll(p);
            }
        }
        return importedProjects;
    }

    private static void checkoutBranchIfNecessary(ProjectReference projectReference, IProgressMonitor monitor) throws TeamException {
        RepositoryMapping mapping;
        String projectName = new Path(projectReference.getProjectDir()).lastSegment();
        IProject projectInWorkspace = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (projectInWorkspace != null && (mapping = RepositoryMapping.getMapping(projectInWorkspace)) != null) {
            String currentBranch;
            Repository repository = mapping.getRepository();
            try {
                currentBranch = repository.getBranch();
            }
            catch (IOException e) {
                throw new TeamException(e.getMessage());
            }
            if (RepositoryUtil.isDetachedHead(repository)) {
                currentBranch = RepositoryUtil.INSTANCE.mapCommitToRef(repository, currentBranch, false);
            }
            if (RepositoryUtil.hasChanges(repository)) {
                throw new TeamException(MessageFormat.format("Repository at folder {0} has uncommitted changes.", repository.getWorkTree()));
            }
            String configuredBranch = projectReference.getBranch();
            if (!configuredBranch.equals(currentBranch)) {
                String branchName = projectReference.getBranch();
                Ref ref = null;
                try {
                    ref = mapping.getRepository().getRefDatabase().findRef(branchName);
                }
                catch (IOException e) {
                    throw new TeamException(e.getMessage());
                }
                if (ref == null) {
                    CreateLocalBranchOperation createLocalBranchOperation = new CreateLocalBranchOperation(mapping.getRepository(), branchName, ref, BranchConfig.BranchRebaseMode.NONE);
                    try {
                        createLocalBranchOperation.execute(monitor);
                    }
                    catch (CoreException e) {
                        throw new TeamException(e.getMessage());
                    }
                }
                BranchOperation branchOperation = new BranchOperation(repository, configuredBranch);
                try {
                    branchOperation.execute(monitor);
                }
                catch (CoreException e) {
                    throw new TeamException(e.getMessage());
                }
            }
        }
    }

    private static File cloneIfNecessary(URIish gitUrl, String refToCheckout, IPath workDir, Set<ProjectReference> projects, IProgressMonitor monitor) throws TeamException, InterruptedException {
        File repositoryPath = workDir.append(".git").toFile();
        if (workDir.toFile().exists()) {
            if (ProjectReferenceImporter.repositoryAlreadyExistsForUrl(repositoryPath, gitUrl)) {
                return repositoryPath;
            }
            LinkedList<String> projectNames = new LinkedList<String>();
            for (ProjectReference projectReference : projects) {
                projectNames.add(projectReference.getProjectDir());
            }
            throw new TeamException(NLS.bind((String)CoreText.GitProjectSetCapability_CloneToExistingDirectory, (Object[])new Object[]{workDir, projectNames, gitUrl}));
        }
        try {
            int timeout = GitSettings.getRemoteConnectionTimeout();
            CloneOperation cloneOperation = new CloneOperation(gitUrl, true, null, workDir.toFile(), refToCheckout, "origin", timeout);
            cloneOperation.run(monitor);
            return repositoryPath;
        }
        catch (InvocationTargetException e) {
            throw ProjectReferenceImporter.getTeamException(e);
        }
    }

    private Map<URIish, Map<String, Set<ProjectReference>>> parseReferenceStrings() throws TeamException {
        LinkedHashMap<URIish, Map<String, Set<ProjectReference>>> repositories = new LinkedHashMap<URIish, Map<String, Set<ProjectReference>>>();
        String[] stringArray = this.referenceStrings;
        int n = this.referenceStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String reference = stringArray[n2];
            if (reference != null) {
                try {
                    ProjectReference projectReference = new ProjectReference(reference);
                    Set projectReferences = repositories.computeIfAbsent(projectReference.getRepository(), repo -> new HashMap()).computeIfAbsent(projectReference.getBranch(), branch -> new LinkedHashSet());
                    projectReferences.add(projectReference);
                }
                catch (IllegalArgumentException | URISyntaxException e) {
                    throw new TeamException(reference, (Throwable)e);
                }
            }
            ++n2;
        }
        return repositories;
    }

    private static IPath getWorkingDir(URIish gitUrl, String branch, Set<String> allBranches) {
        Path defaultRepoLocation = new Path(RepositoryUtil.getDefaultRepositoryDir());
        String humanishName = gitUrl.getHumanishName();
        Object extendedName = allBranches.size() == 1 || branch.equals("master") ? humanishName : humanishName + "_" + branch;
        return defaultRepoLocation.append((String)extendedName);
    }

    static File findConfiguredRepository(URIish gitUrl) {
        for (String repoDir : RepositoryUtil.INSTANCE.getConfiguredRepositories()) {
            File repoDirFile = new File(repoDir);
            if (!ProjectReferenceImporter.repositoryAlreadyExistsForUrl(repoDirFile, gitUrl)) continue;
            return repoDirFile;
        }
        return null;
    }

    private static boolean repositoryAlreadyExistsForUrl(File repositoryPath, URIish gitUrl) {
        if (repositoryPath.exists()) {
            Repository existingRepository;
            try {
                existingRepository = FileRepositoryBuilder.create((File)repositoryPath);
            }
            catch (IOException e) {
                return false;
            }
            try {
                boolean exists;
                boolean bl = exists = ProjectReferenceImporter.containsRemoteForUrl((Config)existingRepository.getConfig(), gitUrl);
                return bl;
            }
            catch (URISyntaxException e) {
                return false;
            }
            finally {
                existingRepository.close();
            }
        }
        return false;
    }

    private static boolean containsRemoteForUrl(Config config, URIish url) throws URISyntaxException {
        Set remotes = config.getSubsections("remote");
        for (String remote : remotes) {
            URIish canonUrl;
            String remoteUrl = config.getString("remote", remote, "url");
            URIish existingUrl = new URIish(remoteUrl);
            if (existingUrl.equals((Object)url)) {
                return true;
            }
            URIish canonExistingUrl = ProjectReferenceImporter.canonicalizeURL(existingUrl);
            if (!canonExistingUrl.equals((Object)(canonUrl = ProjectReferenceImporter.canonicalizeURL(url)))) continue;
            return true;
        }
        return false;
    }

    private static URIish canonicalizeURL(URIish existingUrl) {
        URIish newURL = existingUrl.setUser(null);
        String path = existingUrl.getPath();
        if (path.endsWith(".git")) {
            newURL = newURL.setPath(path.substring(0, path.lastIndexOf(".git")));
        }
        return newURL;
    }

    private List<IProject> importProjects(Set<ProjectReference> projects, IPath workDir, File repositoryPath, IProgressMonitor monitor) throws TeamException {
        try {
            ArrayList<IProject> importedProjects = new ArrayList<IProject>();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)projects.size());
            for (ProjectReference projectToImport : projects) {
                SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(1), (int)3);
                IPath projectDir = workDir.append(projectToImport.getProjectDir());
                IProjectDescription projectDescription = workspace.loadProjectDescription(projectDir.append(".project"));
                IProject project = root.getProject(projectDescription.getName());
                if (!project.exists()) {
                    project.create(projectDescription, (IProgressMonitor)subProgress.newChild(1));
                    importedProjects.add(project);
                }
                subProgress.setWorkRemaining(2);
                project.open((IProgressMonitor)subProgress.newChild(1));
                ConnectProviderOperation connectProviderOperation = new ConnectProviderOperation(project, repositoryPath);
                connectProviderOperation.execute((IProgressMonitor)subProgress.newChild(1));
            }
            return importedProjects;
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }

    private static TeamException getTeamException(Throwable throwable) {
        Throwable current = throwable;
        while (current.getCause() != null) {
            current = current.getCause();
        }
        return new TeamException(current.getMessage(), current);
    }
}

