/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core.ui;

import org.eclipse.embedcdt.core.Activator;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.core.ui.DirectoryNotStrictFieldEditor;
import org.eclipse.swt.widgets.Composite;

public class DirectoryNotStrictVariableFieldEditor
extends DirectoryNotStrictFieldEditor {
    protected String fVariableName;
    protected String fVariableDescription;

    public DirectoryNotStrictVariableFieldEditor(String buildToolsPathKey, String variableName, String variableDescription, String toolsPaths_label, Composite fieldEditorParent, boolean isStrict) {
        super(buildToolsPathKey, toolsPaths_label, fieldEditorParent, isStrict);
        this.fVariableName = variableName;
        this.fVariableDescription = variableDescription;
    }

    protected void doLoad() {
        if (this.getTextControl() != null) {
            String value = EclipseUtils.getVariableValue(this.fVariableName);
            if (value == null || value.isEmpty()) {
                value = this.getPreferenceStore().getString(this.getPreferenceName());
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("DirectoryNotStrictVariableFieldEditor.doLoad() got \"" + value + "\"");
                }
                this.setPresentsDefaultValue(false);
            }
            this.getTextControl().setText(value);
            this.oldValue = value;
        }
    }

    protected void doStore() {
        String value = this.getTextControl().getText();
        EclipseUtils.setVariableValue(this.fVariableName, this.fVariableDescription, value);
        super.doStore();
    }
}

