/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.property;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.UnknownSerializer;
import com.fasterxml.jackson.databind.ser.std.RawSerializer;
import java.io.IOException;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emfcloud.jackson.annotations.JsonAnnotations;
import org.eclipse.emfcloud.jackson.databind.EMFContext;
import org.eclipse.emfcloud.jackson.databind.deser.RawDeserializer;
import org.eclipse.emfcloud.jackson.databind.deser.ReferenceEntries;
import org.eclipse.emfcloud.jackson.databind.deser.ReferenceEntry;
import org.eclipse.emfcloud.jackson.databind.property.EObjectProperty;
import org.eclipse.emfcloud.jackson.databind.type.FeatureKind;
import org.eclipse.emfcloud.jackson.module.EMFModule;

public class EObjectFeatureProperty
extends EObjectProperty {
    private final EStructuralFeature feature;
    private final JavaType javaType;
    private final boolean defaultValues;
    private JsonSerializer<Object> serializer;
    private JsonDeserializer<Object> deserializer;

    public EObjectFeatureProperty(EStructuralFeature feature, JavaType type, int features) {
        super(JsonAnnotations.getElementName((ENamedElement)feature, features));
        this.feature = feature;
        this.javaType = type;
        this.defaultValues = EMFModule.Feature.OPTION_SERIALIZE_DEFAULT_VALUE.enabledIn(features);
        if (JsonAnnotations.isRawValue(feature)) {
            this.serializer = new RawSerializer(String.class);
            this.deserializer = new RawDeserializer();
        }
    }

    @Override
    public void deserializeAndSet(JsonParser jp, EObject current, DeserializationContext ctxt, Resource resource) throws IOException {
        if (this.deserializer == null) {
            this.deserializer = ctxt.findContextualValueDeserializer(this.javaType, null);
        }
        JsonToken token = null;
        if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
            token = jp.nextToken();
        }
        if (jp.getCurrentToken() == JsonToken.VALUE_NULL) {
            return;
        }
        boolean isMap = false;
        switch (FeatureKind.get((ETypedElement)this.feature)) {
            case MAP: {
                isMap = true;
            }
            case MANY_CONTAINMENT: 
            case SINGLE_CONTAINMENT: {
                EMFContext.setFeature((DatabindContext)ctxt, this.feature);
                EMFContext.setParent((DatabindContext)ctxt, current);
            }
            case SINGLE_ATTRIBUTE: 
            case MANY_ATTRIBUTE: {
                if (this.feature.getEType() instanceof EDataType) {
                    EMFContext.setDataType((DatabindContext)ctxt, this.feature.getEType());
                    Class clazz = this.feature.getEType().getInstanceClass();
                    if (clazz != null && FeatureMap.Entry.class.isAssignableFrom(clazz)) {
                        EMFContext.setParent((DatabindContext)ctxt, current);
                    }
                }
                this.deserializeValue(jp, current, ctxt, token, isMap);
                break;
            }
            case MANY_REFERENCE: 
            case SINGLE_REFERENCE: {
                EMFContext.setFeature((DatabindContext)ctxt, this.feature);
                EMFContext.setParent((DatabindContext)ctxt, current);
                this.deserializeAsReference(jp, ctxt);
                break;
            }
        }
    }

    protected void deserializeAsReference(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ReferenceEntries entries = EMFContext.getEntries((DatabindContext)ctxt);
        if (this.feature.isMany()) {
            this.deserializer.deserialize(jp, ctxt, entries.entries());
        } else {
            Object value = this.deserializer.deserialize(jp, ctxt);
            if (entries != null && value instanceof ReferenceEntry) {
                entries.entries().add((ReferenceEntry)value);
            }
        }
    }

    protected void deserializeValue(JsonParser jp, EObject current, DeserializationContext ctxt, JsonToken token, boolean isMap) throws JsonParseException, IOException, JsonProcessingException {
        if (this.feature.isMany()) {
            if (token != JsonToken.START_ARRAY && !isMap) {
                throw new JsonParseException(jp, "Expected START_ARRAY token, got " + token);
            }
            this.deserializer.deserialize(jp, ctxt, current.eGet(this.feature));
        } else {
            Object value = this.deserializer.deserialize(jp, ctxt);
            if (value != null) {
                current.eSet(this.feature, value);
            }
        }
    }

    @Override
    public void serialize(EObject bean, JsonGenerator jg, SerializerProvider provider) throws IOException {
        Object value;
        if (this.serializer == null) {
            this.serializer = provider.findValueSerializer(this.javaType);
        }
        EMFContext.setParent((DatabindContext)provider, bean);
        EMFContext.setFeature((DatabindContext)provider, this.feature);
        if (bean.eIsSet(this.feature)) {
            Object value2 = bean.eGet(this.feature, false);
            jg.writeFieldName(this.getFieldName());
            if (this.serializer instanceof UnknownSerializer) {
                JsonSerializer other = provider.findValueSerializer(value2.getClass());
                if (other != null) {
                    other.serialize(value2, jg, provider);
                }
            } else {
                this.serializer.serialize(value2, jg, provider);
            }
        } else if (this.defaultValues && (value = this.feature.getDefaultValue()) != null) {
            jg.writeFieldName(this.getFieldName());
            this.serializer.serialize(value, jg, provider);
        }
    }

    @Override
    public EObject deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return null;
    }
}

