/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.resource;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emfcloud.jackson.databind.EMFContext;
import org.eclipse.emfcloud.jackson.databind.ser.FeatureMapEntrySerializer;
import org.eclipse.emfcloud.jackson.utils.EObjects;

public class JsonResource
extends ResourceImpl {
    protected static final Map<EObject, String> DETACHED_EOBJECT_TO_ID_MAP = Collections.synchronizedMap(new WeakHashMap());
    private ObjectMapper mapper;
    private Map<String, EObject> idToEObjectMap;
    private Map<EObject, String> eObjectToIDMap;

    public JsonResource(URI uri, ObjectMapper mapper) {
        super(uri);
        this.mapper = mapper;
    }

    public JsonResource(URI uri) {
        super(uri);
    }

    public void setObjectMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    protected boolean isAttachedDetachedHelperRequired() {
        return this.useIDs() || super.isAttachedDetachedHelperRequired();
    }

    protected boolean useIDs() {
        return this.eObjectToIDMap != null || this.idToEObjectMap != null || this.useUUIDs();
    }

    protected boolean useIDAttributes() {
        return true;
    }

    protected boolean useUUIDs() {
        return false;
    }

    public String getID(EObject eObject) {
        if (this.eObjectToIDMap == null) {
            return null;
        }
        return this.eObjectToIDMap.get(eObject);
    }

    protected EObject getEObjectByID(String id) {
        EObject eObject;
        if (this.idToEObjectMap != null && (eObject = this.idToEObjectMap.get(id)) != null) {
            return eObject;
        }
        return super.getEObjectByID(id);
    }

    protected String getIDForEObject(EObject eObject) {
        return Optional.ofNullable(this.getID(eObject)).orElseGet(() -> super.getIDForEObject(eObject));
    }

    public String getURIFragment(EObject eObject) {
        boolean supportIDRelativeURIFragmentPaths;
        String id = this.getIDForEObject(eObject);
        if (id != null) {
            return id;
        }
        InternalEObject internalEObject = (InternalEObject)eObject;
        if (this.isContainedRoot(internalEObject)) {
            return "/" + this.getURIFragmentRootSegment(eObject);
        }
        SegmentSequence.Builder builder = SegmentSequence.newBuilder((String)"/");
        boolean isContained = this.buildURIFragmentPath(builder, internalEObject, supportIDRelativeURIFragmentPaths = this.supportIDRelativeURIFragmentPaths());
        if (!isContained) {
            return "/-1";
        }
        builder.append("");
        builder.reverse();
        return builder.toSegmentSequence().toString();
    }

    protected EObject getEObject(List<String> uriFragmentPath) {
        int size = uriFragmentPath.size();
        EObject eObject = this.getEObjectForURIFragmentRootSegment(size == 0 ? "" : uriFragmentPath.get(0));
        boolean skipFeatureMapEntryFragment = true;
        for (int i = 1; i < size && eObject != null; ++i) {
            if (EObjects.isFeatureMapEntry(eObject.eContainingFeature())) {
                if (skipFeatureMapEntryFragment) {
                    skipFeatureMapEntryFragment = false;
                    continue;
                }
                eObject = ((InternalEObject)eObject).eObjectForURIFragmentSegment(uriFragmentPath.get(i));
                skipFeatureMapEntryFragment = true;
                continue;
            }
            eObject = ((InternalEObject)eObject).eObjectForURIFragmentSegment(uriFragmentPath.get(i));
        }
        return eObject;
    }

    private boolean buildURIFragmentPath(SegmentSequence.Builder builder, InternalEObject eObject, boolean supportIDRelativeURIFragmentPaths) {
        InternalEObject container = eObject.eInternalContainer();
        if (container != null) {
            String id;
            if (EObjects.isFeatureMapEntry(eObject.eContainingFeature())) {
                String generalFeatureName = EObjects.getGroupNameForFeatureMapEntry(eObject.eContainingFeature());
                EStructuralFeature generalFeature = eObject.eContainer().eClass().getEStructuralFeature(generalFeatureName);
                int index = this.findEntryIndex(eObject, generalFeature);
                StringBuilder fragment = new StringBuilder();
                fragment.append('@');
                fragment.append(generalFeatureName);
                fragment.append('.');
                fragment.append(index);
                fragment.append('/');
                if (this.useKeyAndValueForFeatureMapEntry()) {
                    fragment.append("value");
                } else {
                    fragment.append(eObject.eContainingFeature().getName());
                }
                builder.append(fragment.toString());
            } else {
                builder.append(container.eURIFragmentSegment(eObject.eContainingFeature(), (EObject)eObject));
            }
            if (supportIDRelativeURIFragmentPaths && (id = this.getIDForEObject((EObject)container)) != null) {
                builder.append("?" + id);
                EObject root = EcoreUtil.getRootContainer((EObject)eObject);
                return this.isContainedRoot((InternalEObject)root);
            }
            return this.buildURIFragmentPath(builder, container, supportIDRelativeURIFragmentPaths);
        }
        if (this.isContainedRoot(eObject)) {
            builder.append(this.getURIFragmentRootSegment((EObject)eObject));
            return true;
        }
        return false;
    }

    private boolean useKeyAndValueForFeatureMapEntry() {
        try {
            JsonSerializer ser = this.mapper.getSerializerProviderInstance().findValueSerializer(FeatureMap.Entry.class);
            if (ser instanceof FeatureMapEntrySerializer) {
                return ((FeatureMapEntrySerializer)ser).shouldUseKeyAndValueProperties();
            }
        }
        catch (JsonMappingException e) {
            EcorePlugin.INSTANCE.log((Object)e);
        }
        return false;
    }

    private int findEntryIndex(InternalEObject eObject, EStructuralFeature generalFeatureMap) {
        int index = -1;
        if (generalFeatureMap.isMany()) {
            Object map = eObject.eContainer().eGet(generalFeatureMap);
            if (map instanceof FeatureMap) {
                Iterator it = ((FeatureMap)map).iterator();
                boolean found = false;
                int itIndex = 0;
                while (it.hasNext() && !found) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)it.next();
                    boolean bl = found = eObject.eContainingFeature().equals(entry.getEStructuralFeature()) && eObject.equals(entry.getValue());
                    if (found) {
                        index = itIndex;
                    }
                    ++itIndex;
                }
            }
        } else {
            index = 0;
        }
        return index;
    }

    private boolean isContainedRoot(InternalEObject eObject) {
        return eObject.eDirectResource() == this || this.unloadingContents != null && this.unloadingContents.contains(eObject);
    }

    public void setID(EObject eObject, String id) {
        String oldID;
        String string = oldID = id != null ? this.getEObjectToIDMap().put(eObject, id) : this.getEObjectToIDMap().remove(eObject);
        if (oldID != null) {
            this.getIDToEObjectMap().remove(oldID);
        }
        if (id != null) {
            this.getIDToEObjectMap().put(id, eObject);
        }
    }

    protected void attachedHelper(EObject eObject) {
        super.attachedHelper(eObject);
        String id = this.getID(eObject);
        if (id == null) {
            if (!this.isLoading()) {
                id = DETACHED_EOBJECT_TO_ID_MAP.remove(eObject);
                if (id == null) {
                    id = EcoreUtil.generateUUID();
                }
                this.setID(eObject, id);
            }
        } else {
            this.getIDToEObjectMap().put(id, eObject);
        }
    }

    protected void detachedHelper(EObject eObject) {
        if (this.useIDs() && this.unloadingContents == null) {
            if (this.useUUIDs()) {
                DETACHED_EOBJECT_TO_ID_MAP.put(eObject, this.getID(eObject));
            }
            if (this.idToEObjectMap != null && this.eObjectToIDMap != null) {
                this.setID(eObject, null);
            }
        }
        super.detachedHelper(eObject);
    }

    public Map<String, EObject> getIDToEObjectMap() {
        if (this.idToEObjectMap == null) {
            this.idToEObjectMap = new HashMap<String, EObject>();
        }
        return this.idToEObjectMap;
    }

    public Map<EObject, String> getEObjectToIDMap() {
        if (this.eObjectToIDMap == null) {
            this.eObjectToIDMap = new HashMap<EObject, String>();
        }
        return this.eObjectToIDMap;
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        if (options == null) {
            options = Collections.emptyMap();
        }
        if (inputStream instanceof URIConverter.Loadable) {
            ((URIConverter.Loadable)inputStream).loadResource((Resource)this);
        } else {
            ContextAttributes attributes = EMFContext.from(options).withPerCallAttribute((Object)EMFContext.Attributes.RESOURCE_SET, (Object)this.getResourceSet()).withPerCallAttribute((Object)EMFContext.Attributes.RESOURCE, (Object)this);
            this.mapper.reader().with(attributes).forType(Resource.class).withValueToUpdate((Object)this).readValue(inputStream);
        }
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        if (options == null) {
            options = Collections.emptyMap();
        }
        if (outputStream instanceof URIConverter.Saveable) {
            ((URIConverter.Saveable)outputStream).saveResource((Resource)this);
        } else {
            this.mapper.writer().with(EMFContext.from(options)).writeValue(outputStream, (Object)this);
        }
    }
}

