/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt;

import java.util.Collections;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DetailDialog
extends Dialog {
    private final EObject selection;
    private Adapter objectChangeAdapter;
    private ComposedAdapterFactory composedAdapterFactory;
    private AdapterFactoryItemDelegator adapterFactoryItemDelegator;
    private final VView view;

    @Deprecated
    public DetailDialog(Shell parentShell, EObject selection, VTableControl tableControl) {
        this(parentShell, selection, tableControl, DetailDialog.getView(tableControl));
    }

    public DetailDialog(Shell parentShell, EObject selection, VTableControl tableControl, VView view) {
        super(parentShell);
        this.selection = selection;
        this.view = view;
        this.init();
    }

    private static VView getView(VTableControl tableControl) {
        VView detailView = tableControl.getDetailView();
        if (detailView == null) {
            EStructuralFeature.Setting setting = (EStructuralFeature.Setting)tableControl.getDomainModelReference().getIterator().next();
            EReference reference = (EReference)setting.getEStructuralFeature();
            detailView = ViewProviderHelper.getView((EObject)EcoreUtil.create((EClass)reference.getEReferenceType()), Collections.emptyMap());
        }
        return (VView)EcoreUtil.copy((EObject)detailView);
    }

    protected boolean isResizable() {
        return true;
    }

    private void init() {
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.composedAdapterFactory);
    }

    protected Point getInitialSize() {
        Point p = super.getInitialSize();
        int height = p.y;
        int width = p.x;
        if (height > 800) {
            height = Math.round((float)height / 1.5f);
        }
        if (width < 600) {
            width = Math.round((float)width * 1.5f);
        }
        return new Point(width, height);
    }

    protected Control createDialogArea(Composite parent) {
        this.updateTitle();
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 768);
        scrolledComposite.setBackground(composite.getBackground());
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        Composite content = new Composite((Composite)scrolledComposite, 0);
        content.setBackground(composite.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(content);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)content);
        try {
            ECPSWTViewRenderer.INSTANCE.render(content, this.selection, this.view);
        }
        catch (ECPRendererException ex) {
            ex.printStackTrace();
        }
        scrolledComposite.setContent((Control)content);
        Point point = content.computeSize(-1, -1);
        content.setSize(point);
        scrolledComposite.setMinSize(point);
        this.objectChangeAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                super.notifyChanged(msg);
                DetailDialog.this.updateTitle();
            }
        };
        this.selection.eAdapters().add((Object)this.objectChangeAdapter);
        return composite;
    }

    private void updateTitle() {
        this.getShell().setText(this.getDefaultText(this.selection));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
    }

    private String getDefaultText(EObject eObject) {
        return this.adapterFactoryItemDelegator.getText((Object)eObject);
    }

    public boolean close() {
        if (this.objectChangeAdapter != null) {
            this.selection.eAdapters().remove((Object)this.objectChangeAdapter);
        }
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
        return super.close();
    }
}

