/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.internal.client.importexport.ExportImportControllerExecutor;
import org.eclipse.emf.emfstore.internal.client.importexport.IExportImportController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.util.EMFStorePreferenceHelper;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIGenericExportImportController
extends AbstractEMFStoreUIController<Void> {
    private final IExportImportController controller;
    private File file;

    public UIGenericExportImportController(Shell shell, IExportImportController controller) {
        super(shell);
        this.controller = controller;
    }

    @Override
    public boolean preRun() {
        this.file = this.selectFile();
        return this.file != null;
    }

    private File selectFile() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.controller.isExport() ? 8192 : 4096);
        dialog.setFilterNames(this.controller.getFilteredNames());
        dialog.setFilterExtensions(this.controller.getFilteredExtensions());
        dialog.setOverwrite(true);
        if (this.controller.getParentFolderPropertyKey() != null) {
            String initialPath = EMFStorePreferenceHelper.getPreference(this.controller.getParentFolderPropertyKey(), System.getProperty("user.home"));
            dialog.setFilterPath(initialPath);
        }
        dialog.setFileName(this.controller.getFilename());
        String fn = dialog.open();
        if (fn == null) {
            return null;
        }
        File file = new File(dialog.getFilterPath(), dialog.getFileName());
        return file;
    }

    @Override
    public Void doRun(IProgressMonitor progressMonitor) throws ESException {
        EMFStorePreferenceHelper.setPreference(this.controller.getParentFolderPropertyKey(), this.file.getParent());
        try {
            new ExportImportControllerExecutor(this.file, progressMonitor).execute(this.controller);
            MessageDialog.openInformation((Shell)this.getShell(), (String)(this.controller.isExport() ? "Export" : "Import successfull"), (String)("The " + this.controller.getLabel() + " has been successfully " + (this.controller.isExport() ? "exported." : "imported.")));
        }
        catch (IOException e) {
            EMFStoreMessageDialog.showExceptionDialog(this.getShell(), (Exception)e);
        }
        return null;
    }
}

