/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge;

import java.util.ArrayList;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.ui.DecisionBox;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.util.UIDecisionConfig;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class MergeWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "Resolve Conflicts";
    private ArrayList<DecisionBox> decisionBoxes;
    private DecisionManager decisionManager;

    protected MergeWizardPage(DecisionManager decisionManager) {
        super(PAGE_NAME);
        this.decisionManager = decisionManager;
        this.setTitle("Merge Conflicts");
        int countMyOperations = decisionManager.countMyOperations();
        int countTheirOperations = decisionManager.countTheirOperations();
        int countMyLeafOperations = decisionManager.countMyLeafOperations();
        int countTheirLeafOperations = decisionManager.countTheirLeafOperations();
        this.setDescription("Some of your " + countMyOperations + " composite changes and " + countMyLeafOperations + " overall changes conflict with " + countTheirOperations + " composite changes and " + countTheirLeafOperations + " overall changes from the repository." + "\nIn order to resolve these issues, select an option for every conflict.");
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite topBar = this.createTopBar(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)topBar);
        final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        GridDataFactory.fillDefaults().align(1, 1).grab(true, true).applyTo((Control)scrolledComposite);
        final Composite client = new Composite((Composite)scrolledComposite, 0);
        client.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(4, 4, true, true);
        client.setLayoutData((Object)gridData);
        ColorSwitcher colorSwitcher = new ColorSwitcher();
        this.decisionBoxes = new ArrayList();
        ArrayList<VisualConflict> unresolvedConflicts = new ArrayList<VisualConflict>();
        for (VisualConflict conflict : this.decisionManager.getConflicts()) {
            if (conflict.isResolved()) continue;
            unresolvedConflicts.add(conflict);
        }
        for (VisualConflict conflict : unresolvedConflicts) {
            this.decisionBoxes.add(new DecisionBox(client, this.decisionManager, colorSwitcher.getColor(), conflict));
        }
        client.addListener(11, new Listener(){
            int widthBeforeChange = -1;

            public void handleEvent(Event event) {
                int widthAfterChange = client.getSize().x;
                if (this.widthBeforeChange != widthAfterChange) {
                    scrolledComposite.setMinHeight(client.computeSize((int)widthAfterChange, (int)-1).y);
                    this.widthBeforeChange = widthAfterChange;
                }
            }
        });
        scrolledComposite.setContent((Control)client);
        Point computeSize = this.calcParentSize(parent, topBar);
        scrolledComposite.setMinSize(computeSize);
        this.setControl((Control)scrolledComposite);
    }

    private Point calcParentSize(Composite parent, Composite topBar) {
        Point computeSize = parent.computeSize(-1, -1);
        computeSize.x = parent.getBounds().width;
        computeSize.y = computeSize.y + topBar.getSize().y + 50;
        return computeSize;
    }

    private Composite createTopBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(256));
        composite.setSize(-1, 200);
        Button acceptMine = new Button(composite, 8);
        acceptMine.setText("Keep All My Changes");
        acceptMine.addSelectionListener((SelectionListener)new SelectAllSelectionListener(ConflictOption.OptionType.MyOperation));
        Button accecptTheirs = new Button(composite, 8);
        accecptTheirs.setText("Keep All Their Changes");
        accecptTheirs.addSelectionListener((SelectionListener)new SelectAllSelectionListener(ConflictOption.OptionType.TheirOperation));
        return composite;
    }

    private final class ColorSwitcher {
        private boolean color = false;

        public Color getColor() {
            this.color = !this.color;
            return this.color ? UIDecisionConfig.getFirstDecisionBoxColor() : UIDecisionConfig.getSecondDecisionBoxColor();
        }
    }

    private final class SelectAllSelectionListener
    implements SelectionListener {
        private final ConflictOption.OptionType type;

        public SelectAllSelectionListener(ConflictOption.OptionType type) {
            this.type = type;
        }

        public void widgetSelected(SelectionEvent e) {
            this.select();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.select();
        }

        private void select() {
            boolean confirm;
            if (this.type.equals((Object)ConflictOption.OptionType.MyOperation) && !(confirm = MessageDialog.openConfirm((Shell)MergeWizardPage.this.getShell(), (String)"Override changes of other users", (String)("Are you sure you want to override " + MergeWizardPage.this.decisionManager.countTheirOperations() + " composite operations and " + MergeWizardPage.this.decisionManager.countTheirLeafOperations() + " overall changes of other users by keeping your changes?")))) {
                return;
            }
            block0: for (DecisionBox box : MergeWizardPage.this.decisionBoxes) {
                for (ConflictOption option : box.getConflict().getOptions()) {
                    if (!option.getType().equals((Object)this.type)) continue;
                    box.setSolution(option);
                    continue block0;
                }
            }
        }
    }
}

