/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.irix;

import java.io.PrintStream;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.impl.PatternCompiler;

public class SetupJenaIRI {
    private static final IRIFactory iriFactoryInst = SetupJenaIRI.setupIRIFactory();
    private static final IRIFactory iriCheckerInst = SetupJenaIRI.setupCheckerIRIFactory();

    public static IRIFactory iriFactory() {
        return iriFactoryInst;
    }

    public static IRIFactory iriCheckerFactory() {
        return iriCheckerInst;
    }

    static final IRIFactory setupIRIFactory() {
        return SetupJenaIRI.setupCheckerIRIFactory();
    }

    static final IRIFactory setupCheckerIRIFactory() {
        IRIFactory iriCheckerFactory = new IRIFactory();
        iriCheckerFactory.useSpecificationIRI(true);
        iriCheckerFactory.useSchemeSpecificRules("*", true);
        iriCheckerFactory.setSameSchemeRelativeReferences("file");
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 11, false, true);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 1, false, false);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 61, false, true);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 44, false, false);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 45, false, false);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 28, false, false);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 29, false, false);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 12, false, true);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 15, false, true);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 13, false, true);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 14, false, false);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 36, false, true);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 58, false, true);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 8, false, false);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 47, false, false);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 56, false, false);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 49, false, false);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 52, false, false);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 2, false, true);
        SetupJenaIRI.setErrorWarning(iriCheckerFactory, 3, false, true);
        return iriCheckerFactory;
    }

    static void setErrorWarning(IRIFactory factory, int code, boolean isError, boolean isWarning) {
        factory.setIsWarning(code, isWarning);
        factory.setIsError(code, isError);
    }

    private static void printErrorWarning(PrintStream ps, IRIFactory factory, int code) {
        String x = PatternCompiler.errorCodeName(code);
        ps.printf("%-40s : E:%-5s W:%-5s\n", x, factory.isError(code), factory.isWarning(code));
    }
}

