/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.common.OntConfig;
import org.apache.jena.ontapi.common.OntEnhNodeFactories;
import org.apache.jena.ontapi.common.OntPersonality;
import org.apache.jena.ontapi.model.OntModel;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.rdf.model.RDFNode;

public interface OntEnhGraph {
    public static OntEnhGraph asPersonalityModel(EnhGraph graph) throws OntJenaException {
        if (graph instanceof OntEnhGraph) {
            return (OntEnhGraph)((Object)graph);
        }
        throw new OntJenaException.IllegalArgument("The given EnhGraph is not a PersonalityModel: " + graph);
    }

    public static OntEnhGraph asPersonalityModel(OntModel graph) throws OntJenaException {
        if (graph instanceof OntEnhGraph) {
            return (OntEnhGraph)((Object)graph);
        }
        throw new OntJenaException.IllegalArgument("The given OntGraphModel is not a PersonalityModel: " + graph);
    }

    public static OntConfig config(EnhGraph graph) {
        return OntEnhGraph.asPersonalityModel(graph).getOntPersonality().getConfig();
    }

    public static boolean canAs(Class<? extends RDFNode> view, Node node, EnhGraph graph) {
        return OntEnhGraph.asPersonalityModel(graph).canNodeAs(view, node);
    }

    public OntPersonality getOntPersonality();

    public <N extends RDFNode> N getNodeAs(Node var1, Class<N> var2);

    public <N extends RDFNode> N findNodeAs(Node var1, Class<N> var2);

    public <N extends RDFNode> N safeFindNodeAs(Node var1, Class<N> var2);

    default public boolean canNodeAs(Class<? extends RDFNode> view, Node node) {
        return this.safeFindNodeAs(node, view) != null;
    }

    default public <X extends OntObject> void checkType(Class<X> type) {
        OntJenaException.checkSupported(this.getOntPersonality().supports(type), "Profile " + this.getOntPersonality().getName() + " does not support language construct " + OntEnhNodeFactories.viewAsString(type));
    }
}

