/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.out.NodeFormatterBase;
import org.apache.jena.riot.out.quoted.QuotedStringOutput;
import org.apache.jena.riot.out.quoted.QuotedStringOutputNT;
import org.apache.jena.riot.out.quoted.QuotedURI;

public class NodeFormatterNT
extends NodeFormatterBase {
    private final QuotedStringOutput quotedStringProc;
    private final QuotedURI quotedUriProc;

    public NodeFormatterNT() {
        this(CharSpace.UTF8);
    }

    public NodeFormatterNT(CharSpace charSpace) {
        this.quotedStringProc = new QuotedStringOutputNT(charSpace);
        this.quotedUriProc = new QuotedURI(charSpace);
    }

    @Override
    public void formatURI(AWriter w, String uriStr) {
        this.quotedUriProc.writeURI(w, uriStr);
    }

    @Override
    public void formatVar(AWriter w, String name) {
        w.print('?');
        EscapeStr.stringEsc(w, name, false);
    }

    @Override
    public void formatBNode(AWriter w, String label) {
        w.print("_:");
        String lab = NodeFmtLib.encodeBNodeLabel(label);
        w.print(lab);
    }

    @Override
    public void formatLitString(AWriter w, String lex) {
        this.writeEscaped(w, lex);
    }

    private void writeEscaped(AWriter w, String lex) {
        this.quotedStringProc.writeStr(w, lex);
    }

    @Override
    public void formatLitLang(AWriter w, String lex, String langTag) {
        this.writeEscaped(w, lex);
        w.print('@');
        w.print(langTag);
    }

    @Override
    public void formatLitDT(AWriter w, String lex, String datatypeURI) {
        this.writeEscaped(w, lex);
        w.print("^^");
        this.formatURI(w, datatypeURI);
    }
}

