/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.irix.IRIs;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DynamicDatasets;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.OpEval;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.PlanOp;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.DatasetUtils;

public abstract class QueryEngineBase
implements OpEval,
Closeable {
    protected final DatasetGraph originalDataset;
    protected DatasetGraph dataset = null;
    protected Context context;
    private Binding startBinding;
    private Query query = null;
    private Op queryOp = null;
    private Plan plan = null;

    protected QueryEngineBase(Query query, DatasetGraph dsg, Binding input, Context cxt) {
        this(dsg, input, cxt);
        this.query = query;
        query.setResultVars();
        this.setOp(this.createOp(query));
        this.dataset = this.prepareDataset(dsg, query);
    }

    private DatasetGraph prepareDataset(DatasetGraph originalDataset, Query query) {
        DatasetDescription dsDesc = DatasetDescription.create(query, this.context);
        DatasetGraph dsg = originalDataset;
        if (dsg != null) {
            if (dsDesc != null && query.hasDatasetDescription()) {
                dsg = this.dynamicDataset(dsDesc, dsg, false);
            }
            return dsg;
        }
        if (!query.hasDatasetDescription()) {
            throw new QueryExecException("No dataset and no dataset description for query");
        }
        String baseURI = query.getBaseURI();
        if (baseURI == null) {
            baseURI = IRIs.getSystemBase().str();
        }
        dsg = DatasetUtils.createDatasetGraph(dsDesc, baseURI);
        return dsg;
    }

    protected QueryEngineBase(Op op, DatasetGraph dataset, Binding input, Context cxt) {
        this(dataset, input, cxt);
        if (this.context == null) {
            this.context = Context.setupContextForDataset(this.context, dataset);
        }
        Context.setCurrentDateTime(this.context);
        this.query = null;
        this.setOp(op);
    }

    private QueryEngineBase(DatasetGraph dataset, Binding input, Context context2) {
        this.context = context2;
        this.originalDataset = dataset;
        this.dataset = dataset;
        if (input == null) {
            Log.warn(this, "Null initial input");
            input = BindingRoot.create();
        }
        this.startBinding = input;
    }

    public Plan getPlan() {
        if (this.plan == null) {
            this.plan = this.createPlan();
        }
        return this.plan;
    }

    protected Plan createPlan() {
        Op op = this.queryOp;
        if (!this.startBinding.isEmpty()) {
            op = Substitute.substitute(op, this.startBinding);
            this.context.put(ARQConstants.sysCurrentAlgebra, op);
        }
        op = this.modifyOp(op);
        QueryIterator queryIterator = null;
        queryIterator = this.dataset != null ? this.evaluate(op, this.dataset, this.startBinding, this.context) : this.evaluateNoMgt(op, this.dataset, this.startBinding, this.context);
        return new PlanOp(this.getOp(), this, queryIterator);
    }

    protected Op modifyOp(Op op) {
        return op;
    }

    protected Op createOp(Query query) {
        Op op = Algebra.compile(query);
        return op;
    }

    protected DatasetGraph dynamicDataset(DatasetDescription dsDesc, DatasetGraph dataset, boolean unionDftGraph) {
        return DynamicDatasets.dynamicDataset(dsDesc, dataset, unionDftGraph);
    }

    protected boolean isDynamicDataset() {
        return this.originalDataset != this.dataset;
    }

    @Override
    public final QueryIterator evaluate(Op op, DatasetGraph dsg, Binding binding, Context context2) {
        if (this.query != null) {
            Explain.explain("QUERY", this.query, context2);
        }
        Explain.explain("ALGEBRA", op, context2);
        return this.eval(op, dsg, binding, context2);
    }

    private QueryIterator evaluateNoMgt(Op op, DatasetGraph dsg, Binding binding, Context context2) {
        return this.eval(op, dsg, binding, context2);
    }

    protected abstract QueryIterator eval(Op var1, DatasetGraph var2, Binding var3, Context var4);

    public Op getOp() {
        return this.queryOp;
    }

    protected Binding getStartBinding() {
        return this.startBinding;
    }

    @Override
    public void close() {
    }

    protected void setOp(Op op) {
        this.queryOp = op;
        this.context.put(ARQConstants.sysCurrentAlgebra, op);
    }
}

