/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.assembler;

import java.util.Locale;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.tdb1.TDB1Exception;
import org.apache.jena.tdb1.assembler.VocabTDB;
import org.apache.jena.tdb1.base.file.FileSet;
import org.apache.jena.tdb1.base.file.Location;
import org.apache.jena.tdb1.base.record.RecordFactory;
import org.apache.jena.tdb1.index.IndexFactory;
import org.apache.jena.tdb1.index.RangeIndex;
import org.apache.jena.tdb1.lib.ColumnMap;
import org.apache.jena.tdb1.setup.StoreParams;
import org.apache.jena.tdb1.store.tupletable.TupleIndex;
import org.apache.jena.tdb1.store.tupletable.TupleIndexRecord;
import org.apache.jena.tdb1.sys.SystemTDB;

public class IndexAssembler
extends AssemblerBase {
    private Location location = null;

    private IndexAssembler() {
        this.location = null;
    }

    private IndexAssembler(Location location) {
        this.location = location;
    }

    @Override
    public TupleIndex open(Assembler a, Resource root2, Mode mode) {
        GraphUtils.exactlyOneProperty(root2, VocabTDB.pDescription);
        String desc = GraphUtils.getAsStringValue(root2, VocabTDB.pDescription).toUpperCase(Locale.ENGLISH);
        GraphUtils.exactlyOneProperty(root2, VocabTDB.pFile);
        String filename = GraphUtils.getAsStringValue(root2, VocabTDB.pFile);
        if (this.location != null) {
            filename = this.location.absolute(filename);
        }
        String primary = null;
        RecordFactory rf = null;
        switch (desc.length()) {
            case 3: {
                primary = "SPO";
                rf = SystemTDB.indexRecordTripleFactory;
                break;
            }
            case 4: {
                primary = "GSPO";
                rf = SystemTDB.indexRecordQuadFactory;
                break;
            }
            default: {
                throw new TDB1Exception("Bad length for index description: " + desc);
            }
        }
        FileSet fileset = null;
        StoreParams idxParams = StoreParams.getDftStoreParams();
        RangeIndex rIndex = IndexFactory.buildRangeIndex(fileset, rf, idxParams);
        return new TupleIndexRecord(desc.length(), new ColumnMap(primary, desc), desc, rf, rIndex);
    }
}

