/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cssparser.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSCharsetRuleImpl;
import org.htmlunit.cssparser.dom.CSSImportRuleImpl;
import org.htmlunit.cssparser.dom.CSSRuleListImpl;
import org.htmlunit.cssparser.dom.CSSStyleRuleImpl;
import org.htmlunit.cssparser.dom.DOMExceptionImpl;
import org.htmlunit.cssparser.dom.MediaListImpl;
import org.htmlunit.cssparser.parser.CSSException;
import org.htmlunit.cssparser.parser.CSSOMParser;
import org.htmlunit.cssparser.parser.media.MediaQuery;
import org.htmlunit.cssparser.parser.media.MediaQueryList;
import org.htmlunit.cssparser.parser.selector.ElementSelector;
import org.htmlunit.cssparser.parser.selector.Selector;
import org.htmlunit.cssparser.util.ParserUtils;
import org.htmlunit.cssparser.util.ThrowCssExceptionErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class CSSStyleSheetImpl
implements Serializable {
    private boolean disabled_;
    private Node ownerNode_;
    private String href_;
    private String title_;
    private MediaListImpl media_;
    private AbstractCSSRuleImpl ownerRule_;
    private CSSRuleListImpl cssRules_;
    private CSSStyleSheetRuleIndex index_;

    public boolean getDisabled() {
        return this.disabled_;
    }

    public void setDisabled(boolean disabled) {
        this.disabled_ = disabled;
    }

    public Node getOwnerNode() {
        return this.ownerNode_;
    }

    public String getHref() {
        return this.href_;
    }

    public String getTitle() {
        return this.title_;
    }

    public MediaListImpl getMedia() {
        return this.media_;
    }

    public AbstractCSSRuleImpl getOwnerRule() {
        return this.ownerRule_;
    }

    public CSSRuleListImpl getCssRules() {
        if (this.cssRules_ == null) {
            this.cssRules_ = new CSSRuleListImpl();
        }
        return this.cssRules_;
    }

    public void insertRule(String rule, int index) throws DOMException {
        try {
            CSSOMParser parser = new CSSOMParser();
            parser.setParentStyleSheet(this);
            parser.setErrorHandler(ThrowCssExceptionErrorHandler.INSTANCE);
            AbstractCSSRuleImpl r = parser.parseRule(rule);
            if (r == null) {
                throw new DOMExceptionImpl(12, 0, "Parsing rule '" + rule + "' failed.");
            }
            if (this.getCssRules().getLength() > 0) {
                int msg = -1;
                if (r instanceof CSSCharsetRuleImpl) {
                    if (index != 0) {
                        msg = 11;
                    } else if (this.getCssRules().getRules().get(0) instanceof CSSCharsetRuleImpl) {
                        msg = 12;
                    }
                } else if (r instanceof CSSImportRuleImpl) {
                    if (index <= this.getCssRules().getLength()) {
                        for (int i = 0; i < index; ++i) {
                            AbstractCSSRuleImpl ri = this.getCssRules().getRules().get(i);
                            if (ri instanceof CSSCharsetRuleImpl || ri instanceof CSSImportRuleImpl) continue;
                            msg = 13;
                            break;
                        }
                    }
                } else if (index <= this.getCssRules().getLength()) {
                    for (int i = index; i < this.getCssRules().getLength(); ++i) {
                        AbstractCSSRuleImpl ri = this.getCssRules().getRules().get(i);
                        if (!(ri instanceof CSSCharsetRuleImpl) && !(ri instanceof CSSImportRuleImpl)) continue;
                        msg = 16;
                        break;
                    }
                }
                if (msg > -1) {
                    throw new DOMExceptionImpl(3, msg);
                }
            }
            this.getCssRules().insert(r, index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DOMExceptionImpl(1, 1, e.getMessage());
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public void deleteRule(int index) throws DOMException {
        try {
            this.getCssRules().delete(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DOMExceptionImpl(1, 1, e.getMessage());
        }
    }

    public void setOwnerNode(Node ownerNode) {
        this.ownerNode_ = ownerNode;
    }

    public void setHref(String href) {
        this.href_ = href;
    }

    public void setTitle(String title) {
        this.title_ = title;
    }

    public void setMediaText(String mediaText) {
        if (mediaText == null || mediaText.length() == 0) {
            MediaQueryList sml = new MediaQueryList();
            sml.add(new MediaQuery(null));
            this.media_ = new MediaListImpl(sml);
            return;
        }
        try {
            CSSOMParser parser = new CSSOMParser();
            MediaQueryList sml = parser.parseMedia(mediaText);
            this.media_ = new MediaListImpl(sml);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setOwnerRule(AbstractCSSRuleImpl ownerRule) {
        this.ownerRule_ = ownerRule;
    }

    public void setCssRules(CSSRuleListImpl rules) {
        this.cssRules_ = rules;
    }

    public String toString() {
        return this.getCssRules().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSStyleSheetImpl)) {
            return false;
        }
        CSSStyleSheetImpl css = (CSSStyleSheetImpl)obj;
        boolean eq = ParserUtils.equals(this.getCssRules(), css.getCssRules());
        eq = eq && this.getDisabled() == css.getDisabled();
        eq = eq && ParserUtils.equals(this.getHref(), css.getHref());
        eq = eq && ParserUtils.equals(this.getMedia(), css.getMedia());
        eq = eq && ParserUtils.equals(this.getTitle(), css.getTitle());
        return eq;
    }

    public int hashCode() {
        int hash = 17;
        hash = ParserUtils.hashCode(hash, this.cssRules_);
        hash = ParserUtils.hashCode(hash, this.disabled_);
        hash = ParserUtils.hashCode(hash, this.href_);
        hash = ParserUtils.hashCode(hash, this.media_);
        hash = ParserUtils.hashCode(hash, this.ownerNode_);
        hash = ParserUtils.hashCode(hash, this.title_);
        return hash;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.cssRules_);
        out.writeBoolean(this.disabled_);
        out.writeObject(this.href_);
        out.writeObject(this.media_);
        out.writeObject(this.title_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.cssRules_ = (CSSRuleListImpl)in.readObject();
        if (this.cssRules_ != null) {
            for (int i = 0; i < this.cssRules_.getLength(); ++i) {
                AbstractCSSRuleImpl cssRule = this.cssRules_.getRules().get(i);
                cssRule.setParentStyleSheet(this);
            }
        }
        this.disabled_ = in.readBoolean();
        this.href_ = (String)in.readObject();
        this.media_ = (MediaListImpl)in.readObject();
        this.title_ = (String)in.readObject();
    }

    public CSSStyleSheetRuleIndex getRuleIndex() {
        return this.index_;
    }

    public void setRuleIndex(CSSStyleSheetRuleIndex index) {
        this.index_ = index;
    }

    public void resetRuleIndex() {
        this.index_ = null;
    }

    static final class SelectorEntriesIterator
    implements Iterator<SelectorEntry> {
        private final LinkedList<Iterator<SelectorEntry>> iterators_ = new LinkedList();

        SelectorEntriesIterator(CSSStyleSheetRuleIndex index, String elementName, String[] classes) {
            List<SelectorEntry> selectors = index.elementSelectors_.get(null);
            if (!selectors.isEmpty()) {
                this.iterators_.add(selectors.iterator());
            }
            if (!(selectors = index.elementSelectors_.get(elementName)).isEmpty()) {
                this.iterators_.add(selectors.iterator());
            }
            if (classes != null) {
                for (String clazz : classes) {
                    selectors = index.classSelectors_.get("." + clazz);
                    if (selectors != null && !selectors.isEmpty()) {
                        this.iterators_.add(selectors.iterator());
                    }
                    if (elementName == null || (selectors = index.classSelectors_.get(elementName + "." + clazz)) == null || selectors.isEmpty()) continue;
                    this.iterators_.add(selectors.iterator());
                }
            }
            if (index.otherSelectors_ != null && !index.otherSelectors_.isEmpty()) {
                this.iterators_.add(index.otherSelectors_.iterator());
            }
        }

        @Override
        public SelectorEntry next() {
            if (this.iterators_.isEmpty()) {
                return null;
            }
            Iterator<SelectorEntry> iter = this.iterators_.peek();
            if (iter.hasNext()) {
                return iter.next();
            }
            this.iterators_.removeFirst();
            return this.next();
        }

        @Override
        public boolean hasNext() {
            if (this.iterators_.isEmpty()) {
                return false;
            }
            Iterator<SelectorEntry> iter = this.iterators_.peek();
            if (iter.hasNext()) {
                return true;
            }
            this.iterators_.pop();
            return this.hasNext();
        }
    }

    public static class CSSStyleSheetRuleIndex {
        private static final MediaListImpl DEFAULT_MEDIA_LIST = new MediaListImpl(null);
        private final List<CSSStyleSheetRuleIndex> children_ = new ArrayList<CSSStyleSheetRuleIndex>();
        private MediaListImpl mediaList_ = DEFAULT_MEDIA_LIST;
        private final SelectorIndex elementSelectors_ = new SelectorIndex();
        private final SelectorIndex classSelectors_ = new SelectorIndex();
        private final List<SelectorEntry> otherSelectors_ = new ArrayList<SelectorEntry>();

        public void addElementSelector(ElementSelector elementSelector, Selector s, CSSStyleRuleImpl styleRule) {
            String elementName = elementSelector.getLocalNameLowerCase();
            this.elementSelectors_.add(elementName, new SelectorEntry(s, styleRule));
        }

        public void addClassSelector(ElementSelector elementSelector, String className, Selector s, CSSStyleRuleImpl styleRule) {
            String elementName = elementSelector.getLocalNameLowerCase();
            String key = elementName == null ? "." + className : elementName + "." + className;
            this.classSelectors_.add(key, new SelectorEntry(s, styleRule));
        }

        public void addOtherSelector(Selector s, CSSStyleRuleImpl styleRule) {
            SelectorEntry selectorEntry = new SelectorEntry(s, styleRule);
            this.otherSelectors_.add(selectorEntry);
        }

        public CSSStyleSheetRuleIndex addMedia(MediaListImpl mediaList) {
            String media = mediaList.getMediaText();
            for (CSSStyleSheetRuleIndex cssStyleSheetRuleIndex : this.children_) {
                if (!media.equals(cssStyleSheetRuleIndex.getMediaList().getMediaText())) continue;
                return cssStyleSheetRuleIndex;
            }
            CSSStyleSheetRuleIndex index = new CSSStyleSheetRuleIndex();
            index.mediaList_ = mediaList;
            this.children_.add(index);
            return index;
        }

        public MediaListImpl getMediaList() {
            return this.mediaList_;
        }

        public List<CSSStyleSheetRuleIndex> getChildren() {
            return this.children_;
        }

        public Iterator<SelectorEntry> getSelectorEntriesIteratorFor(String elementName, String[] classes) {
            return new SelectorEntriesIterator(this, elementName, classes);
        }

        private static final class SelectorIndex {
            private final Map<String, List<SelectorEntry>> keyToSelectors_ = new HashMap<String, List<SelectorEntry>>();

            private SelectorIndex() {
            }

            void add(String key, SelectorEntry selector) {
                List entry = this.keyToSelectors_.computeIfAbsent(key, k -> new ArrayList());
                entry.add(selector);
            }

            List<SelectorEntry> get(String key) {
                List<SelectorEntry> entry = this.keyToSelectors_.get(key);
                if (entry == null) {
                    return Collections.emptyList();
                }
                return entry;
            }
        }
    }

    public static final class SelectorEntry {
        private final Selector selector_;
        private final CSSStyleRuleImpl rule_;

        SelectorEntry(Selector selector, CSSStyleRuleImpl rule) {
            this.selector_ = selector;
            this.rule_ = rule;
        }

        public Selector getSelector() {
            return this.selector_;
        }

        public CSSStyleRuleImpl getRule() {
            return this.rule_;
        }
    }
}

