/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.internal.build.site.P2Utils;

public class PluginPathFinder {
    private static final String DROPINS = "dropins";
    private static final String LINK = ".link";
    private static final String ECLIPSE = "eclipse";

    private static String getSitePath(String platformHome, File linkFile, boolean features) {
        String prefix = IPath.fromOSString((String)platformHome).removeLastSegments(1).toString();
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileInputStream fis = new FileInputStream(linkFile);){
                properties.load(fis);
                Object path = properties.getProperty("path");
                if (path != null) {
                    if (!IPath.fromOSString((String)path).isAbsolute()) {
                        path = prefix + "/" + (String)path;
                    }
                    path = (String)path + "/eclipse/";
                    path = features ? (String)path + "features" : (String)path + "plugins";
                    if (new File((String)path).exists()) {
                        return path;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static List<File> getSites(String platformHome, boolean features) {
        File[] linkFiles;
        ArrayList<File> sites = new ArrayList<File>();
        File file = new File(platformHome, features ? "features" : "plugins");
        if (!features && !file.exists()) {
            file = new File(platformHome);
        }
        if (file.exists()) {
            sites.add(file);
        }
        if ((linkFiles = new File(platformHome + "/links").listFiles()) != null) {
            File[] fileArray = linkFiles;
            int n = linkFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File linkFile = fileArray[n2];
                String path = PluginPathFinder.getSitePath(platformHome, linkFile, features);
                if (path != null) {
                    sites.add(new File(path));
                }
                ++n2;
            }
        }
        return sites;
    }

    private static List<File> getDropins(String platformHome, boolean features) {
        File[] contents;
        File dropins = new File(platformHome, DROPINS);
        if (!dropins.exists()) {
            return Collections.emptyList();
        }
        ArrayList<File> sites = new ArrayList<File>();
        ArrayList<File> results = new ArrayList<File>();
        File[] fileArray = contents = dropins.listFiles();
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            File content = fileArray[n2];
            if (content.isFile()) {
                if (content.getName().endsWith(LINK)) {
                    String path = PluginPathFinder.getSitePath(platformHome, content, features);
                    if (path != null) {
                        sites.add(new File(path));
                    }
                } else {
                    results.add(content);
                }
            } else if (content.isDirectory() && content.getName().equals(features ? "features" : "plugins")) {
                results.addAll(Arrays.asList(content.listFiles()));
            } else {
                File temp = new File(content, features ? "features" : "plugins");
                if (temp.isDirectory()) {
                    sites.add(temp);
                } else {
                    temp = new File(content, ECLIPSE + File.separator + (features ? "features" : "plugins"));
                    if (temp.isDirectory()) {
                        sites.add(temp);
                    } else {
                        results.add(content);
                    }
                }
            }
            ++n2;
        }
        results.addAll(PluginPathFinder.scanLocations(sites));
        return results;
    }

    public static List<File> getFeaturePaths(String platformHome) {
        return PluginPathFinder.getPaths(platformHome, true, false);
    }

    public static List<File> getPluginPaths(String platformHome, boolean filterP2Base) {
        return PluginPathFinder.getPaths(platformHome, false, filterP2Base);
    }

    public static List<File> getPaths(String platformHome, boolean features, boolean filterP2Base) {
        List<File> files;
        if (filterP2Base && (files = P2Utils.readBundlesTxt(platformHome)) != null && !files.isEmpty()) {
            return files;
        }
        List<File> list = PluginPathFinder.scanLocations(PluginPathFinder.getSites(platformHome, features));
        list.addAll(PluginPathFinder.getDropins(platformHome, features));
        return list;
    }

    private static List<File> scanLocations(List<File> sites) {
        ArrayList<File> result = new ArrayList<File>();
        for (File site : sites) {
            File[] children;
            if (site == null || !site.exists() || (children = site.listFiles()) == null) continue;
            result.addAll(Arrays.asList(children));
        }
        return result;
    }
}

