/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.postchk;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgCopy;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgFile;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgMove;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgOut;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.svg.SvgNameUtils;
import org.eclipse.escet.common.svg.SvgUtils;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class CifSvgPostChecker {
    private final CifPostCheckEnv env;
    private List<SvgFile> fileDecls = Lists.list();
    private List<Pair<SvgCopy, SvgFile>> copyDecls = Lists.list();
    private List<Pair<SvgMove, SvgFile>> moveDecls = Lists.list();
    private List<Pair<SvgOut, SvgFile>> outDecls = Lists.list();
    private List<Pair<SvgIn, SvgFile>> inDecls = Lists.list();
    private Map<String, Document> svgFilesDocMap = Maps.map();
    private Map<String, Map<Element, Position>> copyFileElemMap = Maps.map();
    private Map<String, Map<String, Position>> moveFileIdsMap = Maps.map();
    private Map<String, Map<Pair<String, String>, Position>> outFileIdAttrsMap = Maps.map();
    private Map<String, Map<Text, Pair<String, Position>>> outFileIdTextsMap = Maps.map();
    private Map<String, Map<String, Position>> inFileIdsMap = Maps.map();

    public CifSvgPostChecker(CifPostCheckEnv env) {
        this.env = env;
    }

    public void check(Specification spec) {
        this.collect((ComplexComponent)spec, null);
        this.checkSvgFileDecls();
        this.checkSvgCopyDecls();
        this.checkSvgMoveDecls();
        this.checkSvgInDecls();
        this.checkSvgOutDecls();
    }

    private void collect(ComplexComponent comp, SvgFile svgFile) {
        for (IoDecl ioDecl : comp.getIoDecls()) {
            if (!(ioDecl instanceof SvgFile)) continue;
            svgFile = (SvgFile)ioDecl;
            this.fileDecls.add(svgFile);
            break;
        }
        for (IoDecl ioDecl : comp.getIoDecls()) {
            if (ioDecl instanceof SvgCopy) {
                this.copyDecls.add((Pair<SvgCopy, SvgFile>)Pair.pair((Object)((SvgCopy)ioDecl), (Object)svgFile));
                continue;
            }
            if (ioDecl instanceof SvgMove) {
                this.moveDecls.add((Pair<SvgMove, SvgFile>)Pair.pair((Object)((SvgMove)ioDecl), (Object)svgFile));
                continue;
            }
            if (ioDecl instanceof SvgOut) {
                this.outDecls.add((Pair<SvgOut, SvgFile>)Pair.pair((Object)((SvgOut)ioDecl), (Object)svgFile));
                continue;
            }
            if (!(ioDecl instanceof SvgIn)) continue;
            this.inDecls.add((Pair<SvgIn, SvgFile>)Pair.pair((Object)((SvgIn)ioDecl), (Object)svgFile));
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                this.collect((ComplexComponent)child, svgFile);
            }
        }
    }

    private void checkSvgFileDecls() {
        for (SvgFile decl : this.fileDecls) {
            this.checkSvgFile(decl);
        }
    }

    private void checkSvgCopyDecls() {
        boolean[] checked = new boolean[this.copyDecls.size()];
        boolean errNotExist = false;
        while (true) {
            boolean progress = false;
            int i = 0;
            while (i < checked.length) {
                if (!checked[i]) {
                    Pair<SvgCopy, SvgFile> decl = this.copyDecls.get(i);
                    try {
                        boolean exists = this.checkSvgCopy((SvgCopy)decl.left, (SvgFile)decl.right, errNotExist);
                        if (exists) {
                            checked[i] = true;
                            progress = true;
                        }
                    }
                    catch (SemanticException ex) {
                        checked[i] = true;
                        progress = true;
                    }
                }
                ++i;
            }
            if (progress || progress) continue;
            if (errNotExist) break;
            errNotExist = true;
        }
    }

    private void checkSvgMoveDecls() {
        for (Pair<SvgMove, SvgFile> decl : this.moveDecls) {
            try {
                this.checkSvgMove((SvgMove)decl.left, (SvgFile)decl.right);
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
        }
    }

    private void checkSvgOutDecls() {
        for (Pair<SvgOut, SvgFile> decl : this.outDecls) {
            try {
                this.checkSvgOut((SvgOut)decl.left, (SvgFile)decl.right);
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
        }
    }

    private void checkSvgInDecls() {
        for (Pair<SvgIn, SvgFile> decl : this.inDecls) {
            try {
                this.checkSvgIn((SvgIn)decl.left, (SvgFile)decl.right);
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
        }
    }

    private void checkSvgFile(SvgFile svgFile) {
        Document document;
        String relSvgPath = svgFile.getPath();
        String absSvgPath = this.env.resolveImport(relSvgPath);
        if (this.svgFilesDocMap.containsKey(absSvgPath)) {
            return;
        }
        try {
            document = SvgUtils.loadSvgFileInternal((String)absSvgPath);
        }
        catch (FileNotFoundException e) {
            Position pos = svgFile.getPosition();
            this.env.addProblem(ErrMsg.SVG_FILE_NOT_FOUND, pos, this.env.getFileReportPath(absSvgPath, pos));
            throw new SemanticException();
        }
        catch (DOMException e) {
            Position pos = svgFile.getPosition();
            this.env.addProblem(ErrMsg.SVG_FILE_INVALID_FILE, pos, this.env.getFileReportPath(absSvgPath, pos));
            throw new SemanticException();
        }
        catch (IOException e) {
            Position pos = svgFile.getPosition();
            this.env.addProblem(ErrMsg.SVG_FILE_IO_ERROR, pos, this.env.getFileReportPath(absSvgPath, pos));
            throw new SemanticException();
        }
        this.svgFilesDocMap.put(absSvgPath, document);
    }

    private boolean checkSvgCopy(SvgCopy svgCopy, SvgFile svgFile, boolean errNotExist) {
        Node parent;
        ComplexComponent comp = (ComplexComponent)svgCopy.eContainer();
        String absSvgPath = this.checkDeclSvgFile(comp, svgCopy.getPosition(), svgFile, svgCopy.getSvgFile());
        Document doc = this.svgFilesDocMap.get(absSvgPath);
        Expression idExpr = svgCopy.getId();
        Element elem = this.checkSvgElementId(idExpr, absSvgPath, doc, errNotExist);
        if (elem == null) {
            return false;
        }
        String id = SvgUtils.getSvgElementId((Element)elem);
        this.checkOverlapCopyElems(absSvgPath, svgCopy, elem);
        String pre = "";
        if (svgCopy.getPre() != null) {
            Expression preExpr = svgCopy.getPre();
            if (!CifValueUtils.hasSingleValue((Expression)preExpr, (boolean)false, (boolean)true)) {
                this.env.addProblem(ErrMsg.SVG_NON_STATIC, preExpr.getPosition(), "CIF/SVG copy declaration prefix");
                throw new SemanticException();
            }
            try {
                pre = (String)CifEvalUtils.eval((Expression)preExpr, (boolean)false);
            }
            catch (CifEvalException e) {
                this.env.addProblem(ErrMsg.EVAL_FAILURE, e.expr.getPosition(), e.getMessage());
                throw new SemanticException();
            }
            if (!SvgNameUtils.isValidSvgPrefixName((String)pre)) {
                this.env.addProblem(ErrMsg.SVG_NAME_INVALID, preExpr.getPosition(), "CIF/SVG copy declaration prefix", pre, " prefix");
                throw new SemanticException();
            }
        }
        String post = "";
        if (svgCopy.getPost() != null) {
            Expression postExpr = svgCopy.getPost();
            if (!CifValueUtils.hasSingleValue((Expression)postExpr, (boolean)false, (boolean)true)) {
                this.env.addProblem(ErrMsg.SVG_NON_STATIC, postExpr.getPosition(), "CIF/SVG copy declaration postfix");
                throw new SemanticException();
            }
            try {
                post = (String)CifEvalUtils.eval((Expression)postExpr, (boolean)false);
            }
            catch (CifEvalException e) {
                this.env.addProblem(ErrMsg.EVAL_FAILURE, e.expr.getPosition(), e.getMessage());
                throw new SemanticException();
            }
            if (!SvgNameUtils.isValidSvgPostfixName((String)post)) {
                this.env.addProblem(ErrMsg.SVG_NAME_INVALID, postExpr.getPosition(), "CIF/SVG copy declaration postfix", post, " postfix");
                throw new SemanticException();
            }
        }
        if ((parent = elem.getParentNode()).getNodeType() != 1) {
            Position reportPos = svgCopy.getPosition();
            this.env.addProblem(ErrMsg.SVG_COPY_ROOT, reportPos, id, this.env.getFileReportPath(absSvgPath, reportPos));
            throw new SemanticException();
        }
        Element copy = (Element)elem.cloneNode(true);
        Pair duplIds = SvgUtils.renameElements((Element)copy, (String)pre, (String)post, (Document)doc);
        if (duplIds != null) {
            Position reportPos = svgCopy.getPosition();
            this.env.addProblem(ErrMsg.SVG_COPY_DUPL_ID, reportPos, id, this.env.getFileReportPath(absSvgPath, reportPos), (String)duplIds.left, (String)duplIds.right);
            throw new SemanticException();
        }
        Element parentElement = (Element)parent;
        parentElement.appendChild(copy);
        return true;
    }

    private void checkSvgMove(SvgMove svgMove, SvgFile svgFile) {
        ComplexComponent comp = (ComplexComponent)svgMove.eContainer();
        String absSvgPath = this.checkDeclSvgFile(comp, svgMove.getPosition(), svgFile, svgMove.getSvgFile());
        Document doc = this.svgFilesDocMap.get(absSvgPath);
        Expression idExpr = svgMove.getId();
        Element elem = this.checkSvgElementId(idExpr, absSvgPath, doc, true);
        String id = SvgUtils.getSvgElementId((Element)elem);
        Expression xExpr = svgMove.getX();
        if (!CifValueUtils.hasSingleValue((Expression)xExpr, (boolean)false, (boolean)true)) {
            this.env.addProblem(ErrMsg.SVG_NON_STATIC, xExpr.getPosition(), "CIF/SVG move declaration x coordinate");
            throw new SemanticException();
        }
        try {
            CifEvalUtils.eval((Expression)xExpr, (boolean)false);
        }
        catch (CifEvalException e) {
            this.env.addProblem(ErrMsg.EVAL_FAILURE, e.expr.getPosition(), e.getMessage());
            throw new SemanticException();
        }
        Expression yExpr = svgMove.getY();
        if (!CifValueUtils.hasSingleValue((Expression)yExpr, (boolean)false, (boolean)true)) {
            this.env.addProblem(ErrMsg.SVG_NON_STATIC, yExpr.getPosition(), "CIF/SVG move declaration y coordinate");
            throw new SemanticException();
        }
        try {
            CifEvalUtils.eval((Expression)yExpr, (boolean)false);
        }
        catch (CifEvalException e) {
            this.env.addProblem(ErrMsg.EVAL_FAILURE, e.expr.getPosition(), e.getMessage());
            throw new SemanticException();
        }
        this.checkDuplMoveIds(absSvgPath, svgMove, id);
    }

    private void checkSvgOut(SvgOut svgOut, SvgFile svgFile) {
        Position movePos;
        Map<String, Position> moveIdsMap;
        ComplexComponent comp = (ComplexComponent)svgOut.eContainer();
        String absSvgPath = this.checkDeclSvgFile(comp, svgOut.getPosition(), svgFile, svgOut.getSvgFile());
        Document doc = this.svgFilesDocMap.get(absSvgPath);
        Expression idExpr = svgOut.getId();
        Element elem = this.checkSvgElementId(idExpr, absSvgPath, doc, true);
        String id = SvgUtils.getSvgElementId((Element)elem);
        String attrName = svgOut.getAttr();
        Position attrTextPos = svgOut.getAttrTextPos();
        Text textNode = this.checkMappingAttr(elem, id, attrName, idExpr.getPosition(), attrTextPos, absSvgPath);
        if (textNode == null) {
            this.checkDuplOutputIdAttrPair(absSvgPath, svgOut, id, attrName);
        } else {
            this.checkDuplOutputTextNode(absSvgPath, svgOut, id, textNode);
        }
        if (textNode == null && attrName.equals("transform") && (moveIdsMap = this.moveFileIdsMap.get(absSvgPath)) != null && (movePos = moveIdsMap.get(id)) != null) {
            String movePath = this.env.getFileReportPath(absSvgPath, movePos);
            String outPath = this.env.getFileReportPath(absSvgPath, svgOut.getPosition());
            this.env.addProblem(ErrMsg.SVG_DUPL_MOVE_TRANSFORM, movePos, id, movePath);
            this.env.addProblem(ErrMsg.SVG_DUPL_MOVE_TRANSFORM, svgOut.getPosition(), id, outPath);
        }
    }

    private void checkSvgIn(SvgIn svgIn, SvgFile svgFile) {
        ComplexComponent comp = (ComplexComponent)svgIn.eContainer();
        String absSvgPath = this.checkDeclSvgFile(comp, svgIn.getPosition(), svgFile, svgIn.getSvgFile());
        Document doc = this.svgFilesDocMap.get(absSvgPath);
        Expression idExpr = svgIn.getId();
        Element elem = this.checkSvgElementId(idExpr, absSvgPath, doc, true);
        String id = SvgUtils.getSvgElementId((Element)elem);
        this.checkDuplInputIds(absSvgPath, svgIn, id);
    }

    private String checkDeclSvgFile(ComplexComponent comp, Position declPos, SvgFile compSvgFile, SvgFile declSvgFile) {
        SvgFile svgFile = compSvgFile;
        if (declSvgFile != null) {
            this.checkSvgFile(declSvgFile);
            svgFile = declSvgFile;
        }
        if (svgFile == null) {
            this.env.addProblem(ErrMsg.SVG_DECL_NO_FILE, declPos, CifTextUtils.getComponentText2((ComplexComponent)comp));
            throw new SemanticException();
        }
        String relPath = svgFile.getPath();
        String absPath = this.env.resolveImport(relPath);
        return absPath;
    }

    private Element checkSvgElementId(Expression idExpr, String svgAbsPath, Document doc, boolean errNotExist) {
        String id;
        if (!CifValueUtils.hasSingleValue((Expression)idExpr, (boolean)false, (boolean)true)) {
            this.env.addProblem(ErrMsg.SVG_NON_STATIC, idExpr.getPosition(), "SVG element id");
            throw new SemanticException();
        }
        try {
            id = (String)CifEvalUtils.eval((Expression)idExpr, (boolean)false);
        }
        catch (CifEvalException e) {
            this.env.addProblem(ErrMsg.EVAL_FAILURE, e.expr.getPosition(), e.getMessage());
            throw new SemanticException();
        }
        if (!SvgNameUtils.isValidSvgName((String)id)) {
            this.env.addProblem(ErrMsg.SVG_NAME_INVALID, idExpr.getPosition(), "SVG element id", id, "");
            throw new SemanticException();
        }
        Element elem = doc.getElementById(id);
        if (elem == null && errNotExist) {
            Position pos = idExpr.getPosition();
            this.env.addProblem(ErrMsg.SVG_ELEM_ID_NOT_FOUND, pos, id, this.env.getFileReportPath(svgAbsPath, pos));
            throw new SemanticException();
        }
        return elem;
    }

    private Text checkMappingAttr(Element elem, String id, String attrName, Position idPos, Position attrTextPos, String absSvgPath) {
        if (attrName == null) {
            Text textNode = SvgUtils.getTextNode((Element)elem);
            if (textNode == null) {
                String path = this.env.getFileReportPath(absSvgPath, attrTextPos);
                this.env.addProblem(ErrMsg.SVG_ELEM_NO_TEXT, attrTextPos, id, path);
                throw new SemanticException();
            }
            return textNode;
        }
        if (!SvgNameUtils.isValidSvgName((String)attrName)) {
            this.env.addProblem(ErrMsg.SVG_NAME_INVALID, attrTextPos, "SVG attribute name", attrName, "");
            throw new SemanticException();
        }
        String elemName = elem.getNodeName();
        Set elemAttrNames = SvgNameUtils.getDefinedAttrs((String)elemName);
        if (elemAttrNames == null) {
            path = this.env.getFileReportPath(absSvgPath, idPos);
            this.env.addProblem(ErrMsg.SVG_UNKNOWN_NAME_ELEM, idPos, id, path, elemName);
        } else if (!elemAttrNames.contains(attrName)) {
            path = this.env.getFileReportPath(absSvgPath, idPos);
            this.env.addProblem(ErrMsg.SVG_UNKNOWN_NAME_ATTR, attrTextPos, id, path, elemName, attrName);
        }
        if (attrName.toLowerCase(Locale.US).equals("id")) {
            this.env.addProblem(ErrMsg.SVG_ATTR_UNSUPPORTED, attrTextPos, "id");
        }
        if (attrName.toLowerCase(Locale.US).equals("style")) {
            this.env.addProblem(ErrMsg.SVG_ATTR_UNSUPPORTED, attrTextPos, "style");
        }
        if (attrName.equals("transform")) {
            String elemAttributeValue = elem.getAttribute("transform");
            if (!elemAttributeValue.isBlank()) {
                this.env.addProblem(ErrMsg.SVG_TRANSFORM_OVERWRITE, attrTextPos, elemAttributeValue);
            }
            Node currentNode = elem;
            while (currentNode.getParentNode() != null) {
                Node currentElem;
                String transformValue;
                if (!((currentNode = currentNode.getParentNode()) instanceof Element) || (transformValue = (currentElem = currentNode).getAttribute("transform")).isBlank() || !transformValue.contains("rotate") && !transformValue.contains("scale") && !transformValue.contains("matrix") && !transformValue.contains("skew")) continue;
                String currentElemId = SvgUtils.getSvgElementId((Element)currentElem);
                if (currentElemId == null) {
                    String namelessAncestorString = "a nameless ancestor element";
                    this.env.addProblem(ErrMsg.SVG_TRANSFORM_AFFECTED_BY_ANCESTOR, attrTextPos, transformValue, namelessAncestorString);
                    continue;
                }
                String namedAncestorString = Strings.fmt((String)"its ancestor element with id \"%s\"", (Object[])new Object[]{currentElemId});
                this.env.addProblem(ErrMsg.SVG_TRANSFORM_AFFECTED_BY_ANCESTOR, attrTextPos, transformValue, namedAncestorString);
            }
        }
        return null;
    }

    private void checkOverlapCopyElems(String svgAbsPath, SvgCopy svgCopy, Element rootElem) {
        Map copyElemMap = this.copyFileElemMap.get(svgAbsPath);
        if (copyElemMap == null) {
            copyElemMap = Maps.map();
            copyElemMap.put(rootElem, svgCopy.getPosition());
            this.copyFileElemMap.put(svgAbsPath, copyElemMap);
            return;
        }
        Set elems = Sets.set();
        Node current = rootElem;
        while (current.getParentNode() != null) {
            if (!((current = current.getParentNode()) instanceof Element)) continue;
            elems.add(current);
        }
        NodeList descendants = rootElem.getElementsByTagName("*");
        int i = 0;
        while (i < descendants.getLength()) {
            elems.add((Element)descendants.item(i));
            ++i;
        }
        for (Element elem : elems) {
            Position prevPos = (Position)copyElemMap.get(elem);
            if (prevPos == null) continue;
            String prevPath = this.env.getFileReportPath(svgAbsPath, prevPos);
            String curPath = this.env.getFileReportPath(svgAbsPath, svgCopy.getPosition());
            this.env.addProblem(ErrMsg.SVG_COPY_OVERLAP, prevPos, SvgUtils.getSvgElementId((Element)elem), prevPath, SvgUtils.getSvgElementId((Element)rootElem));
            this.env.addProblem(ErrMsg.SVG_COPY_OVERLAP, svgCopy.getPosition(), SvgUtils.getSvgElementId((Element)rootElem), curPath, SvgUtils.getSvgElementId((Element)elem));
        }
        if (!copyElemMap.containsKey(rootElem)) {
            copyElemMap.put(rootElem, svgCopy.getPosition());
        }
    }

    private void checkDuplMoveIds(String svgAbsPath, SvgMove svgMove, String id) {
        Map moveIdsMap = this.moveFileIdsMap.get(svgAbsPath);
        if (moveIdsMap == null) {
            moveIdsMap = Maps.map();
            moveIdsMap.put(id, svgMove.getPosition());
            this.moveFileIdsMap.put(svgAbsPath, moveIdsMap);
            return;
        }
        Position prevPos = (Position)moveIdsMap.get(id);
        if (prevPos != null) {
            String prevPath = this.env.getFileReportPath(svgAbsPath, prevPos);
            String curPath = this.env.getFileReportPath(svgAbsPath, svgMove.getPosition());
            this.env.addProblem(ErrMsg.SVG_DUPL_MOVE_ID, prevPos, id, prevPath);
            this.env.addProblem(ErrMsg.SVG_DUPL_MOVE_ID, svgMove.getPosition(), id, curPath);
        } else {
            moveIdsMap.put(id, svgMove.getPosition());
        }
    }

    private void checkDuplOutputIdAttrPair(String svgAbsPath, SvgOut svgOut, String id, String attrName) {
        Map outIdAttrsMap = this.outFileIdAttrsMap.get(svgAbsPath);
        if (outIdAttrsMap == null) {
            outIdAttrsMap = Maps.map();
            outIdAttrsMap.put(Pair.pair((Object)id, (Object)attrName), svgOut.getPosition());
            this.outFileIdAttrsMap.put(svgAbsPath, outIdAttrsMap);
            return;
        }
        Pair pair = Pair.pair((Object)id, (Object)attrName);
        Position prevPos = (Position)outIdAttrsMap.get(pair);
        if (prevPos != null) {
            String prevPath = this.env.getFileReportPath(svgAbsPath, prevPos);
            String curPath = this.env.getFileReportPath(svgAbsPath, svgOut.getPosition());
            this.env.addProblem(ErrMsg.SVG_DUPL_OUTPUT_ID_ATTR, prevPos, attrName, id, prevPath);
            this.env.addProblem(ErrMsg.SVG_DUPL_OUTPUT_ID_ATTR, svgOut.getPosition(), attrName, id, curPath);
        } else {
            outIdAttrsMap.put(pair, svgOut.getPosition());
        }
    }

    private void checkDuplOutputTextNode(String svgAbsPath, SvgOut svgOut, String id, Text textNode) {
        Map outIdTextsMap = this.outFileIdTextsMap.get(svgAbsPath);
        if (outIdTextsMap == null) {
            outIdTextsMap = Maps.map();
            outIdTextsMap.put(textNode, Pair.pair((Object)id, (Object)svgOut.getPosition()));
            this.outFileIdTextsMap.put(svgAbsPath, outIdTextsMap);
            return;
        }
        Pair prevPair = (Pair)outIdTextsMap.get(textNode);
        if (prevPair != null) {
            String prevPath = this.env.getFileReportPath(svgAbsPath, (Position)prevPair.right);
            String curPath = this.env.getFileReportPath(svgAbsPath, svgOut.getPosition());
            this.env.addProblem(ErrMsg.SVG_DUPL_OUTPUT_TEXT, (Position)prevPair.right, (String)prevPair.left, id, prevPath);
            this.env.addProblem(ErrMsg.SVG_DUPL_OUTPUT_TEXT, svgOut.getPosition(), (String)prevPair.left, id, curPath);
        } else {
            outIdTextsMap.put(textNode, Pair.pair((Object)id, (Object)svgOut.getPosition()));
        }
    }

    private void checkDuplInputIds(String svgAbsPath, SvgIn svgIn, String id) {
        Map inIdsMap = this.inFileIdsMap.get(svgAbsPath);
        if (inIdsMap == null) {
            inIdsMap = Maps.map();
            inIdsMap.put(id, svgIn.getPosition());
            this.inFileIdsMap.put(svgAbsPath, inIdsMap);
            return;
        }
        Position prevPos = (Position)inIdsMap.get(id);
        if (prevPos != null) {
            String prevPath = this.env.getFileReportPath(svgAbsPath, prevPos);
            String curPath = this.env.getFileReportPath(svgAbsPath, svgIn.getPosition());
            this.env.addProblem(ErrMsg.SVG_DUPL_INPUT_ID, prevPos, id, prevPath);
            this.env.addProblem(ErrMsg.SVG_DUPL_INPUT_ID, svgIn.getPosition(), id, curPath);
        } else {
            inIdsMap.put(id, svgIn.getPosition());
        }
    }
}

