/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.multilevel.partialspecs;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.multilevel.partialspecs.PartialSpecManager;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class PartialSpecsBuilder {
    private final Specification origSpec;

    public PartialSpecsBuilder(Specification origSpec) {
        this.origSpec = origSpec;
    }

    public Specification createPartialSpecification(List<PositionObject> neededObjects) {
        Map<EObject, Collection<EStructuralFeature.Setting>> danglings;
        PartialSpecManager partialMgr = new PartialSpecManager(this.origSpec);
        for (PositionObject element : neededObjects) {
            if (!(element instanceof Automaton)) continue;
            Automaton automaton = (Automaton)element;
            partialMgr.copyAutomatonSkeleton(automaton);
        }
        for (PositionObject object : neededObjects) {
            if (object instanceof Automaton) continue;
            if (object instanceof Invariant) {
                Invariant invariant = (Invariant)object;
                partialMgr.directlyAttachAddedToComponent((EObject)invariant, (EObject)partialMgr.deepcloneAndAdd(invariant));
                continue;
            }
            if (object instanceof InputVariable) {
                InputVariable inp = (InputVariable)object;
                partialMgr.directlyAttachAddedToComponent((EObject)inp, (EObject)partialMgr.deepcloneAndAdd(inp));
                continue;
            }
            throw new AssertionError((Object)("Encountered unexpected needed object to copy: \"" + String.valueOf(object) + "\"."));
        }
        List unresolvedFields = Lists.list();
        while ((danglings = partialMgr.getNextDanglingObjects()) != null) {
            for (Map.Entry entry : danglings.entrySet()) {
                EObject dangling = (EObject)entry.getKey();
                Collection partialConnections = (Collection)entry.getValue();
                EObject contained = this.findOrMakeContained(dangling, partialMgr);
                if (contained == null) {
                    unresolvedFields.add(entry);
                    continue;
                }
                if (dangling.getClass() == contained.getClass()) {
                    for (EStructuralFeature.Setting setting : partialConnections) {
                        setting.set((Object)contained);
                    }
                    continue;
                }
                Assert.check((boolean)(contained instanceof InputVariable));
                for (EStructuralFeature.Setting setting : partialConnections) {
                    EObject partialParent = setting.getEObject();
                    Assert.check((partialParent instanceof LocationExpression || partialParent instanceof DiscVariableExpression ? 1 : 0) != 0);
                    CifType partialParentType = ((Expression)partialParent).getType();
                    InputVariableExpression newParent = CifConstructors.newInputVariableExpression(null, (CifType)partialParentType, (InputVariable)((InputVariable)contained));
                    EMFHelper.updateParentContainment((EObject)partialParent, (EObject)newParent);
                }
            }
        }
        for (Map.Entry entry : unresolvedFields) {
            Field danglingField = (Field)entry.getKey();
            Collection partialConnections = (Collection)entry.getValue();
            EObject copiedField = partialMgr.getCopiedPartialObject((EObject)danglingField);
            Assert.notNull((Object)copiedField);
            for (EStructuralFeature.Setting setting : partialConnections) {
                setting.set((Object)copiedField);
            }
        }
        return partialMgr.getPartialSpec();
    }

    private EObject findOrMakeContained(EObject dangling, PartialSpecManager partialMgr) {
        EObject copiedObj = partialMgr.getCopiedPartialObject(dangling);
        if (copiedObj != null) {
            return copiedObj;
        }
        if (dangling instanceof AlgVariable || dangling instanceof Constant || dangling instanceof EnumDecl || dangling instanceof Event || dangling instanceof InputVariable || dangling instanceof TypeDecl) {
            Declaration clonedDecl = (Declaration)partialMgr.deepcloneAndAdd(dangling);
            partialMgr.directlyAttachAddedToComponent(dangling, (EObject)clonedDecl);
            return clonedDecl;
        }
        if (dangling instanceof EnumLiteral) {
            EnumDecl enumDecl = (EnumDecl)dangling.eContainer();
            EnumDecl copiedEnumDecl = partialMgr.deepcloneAndAdd(enumDecl);
            partialMgr.directlyAttachAddedToComponent((EObject)enumDecl, (EObject)copiedEnumDecl);
            EnumLiteral copiedEnumLit = (EnumLiteral)partialMgr.getCopiedPartialObject(dangling);
            Assert.notNull((Object)copiedEnumLit);
            return copiedEnumLit;
        }
        if (dangling instanceof Location) {
            Location loc = (Location)dangling;
            InputVariable inputVar = CifConstructors.newInputVariable(null, (String)loc.getName(), null, (CifType)CifConstructors.newBoolType());
            partialMgr.addCopiedObject((EObject)loc, (EObject)inputVar);
            partialMgr.directlyAttachAddedToComponent(dangling, (EObject)inputVar);
            return inputVar;
        }
        if (dangling instanceof DiscVariable) {
            DiscVariable dv = (DiscVariable)dangling;
            EObject copiedAut = partialMgr.getCopiedPartialObject(dv.eContainer());
            if (dv.eContainer() instanceof Automaton && copiedAut != null) {
                DiscVariable clonedVar = partialMgr.deepcloneAndAdd(dv);
                partialMgr.directlyAttachAddedToComponent(dangling, (EObject)clonedVar);
                return clonedVar;
            }
            CifType clonedType = partialMgr.deepcloneAndAdd(dv.getType());
            InputVariable inputVar = CifConstructors.newInputVariable(null, (String)dv.getName(), null, (CifType)clonedType);
            partialMgr.addCopiedObject(dangling, (EObject)inputVar);
            partialMgr.directlyAttachAddedToComponent(dangling, (EObject)inputVar);
            return inputVar;
        }
        Assert.check((boolean)(dangling instanceof Field), (Object)("Found unexpected dangling object " + String.valueOf(dangling)));
        return null;
    }
}

