/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm.app;

import org.apache.commons.math3.linear.RealMatrix;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.dsm.ClusterInput;
import org.eclipse.escet.common.dsm.Dsm;
import org.eclipse.escet.common.dsm.DsmClustering;
import org.eclipse.escet.common.dsm.DsmHelper;
import org.eclipse.escet.common.dsm.Group;
import org.eclipse.escet.common.dsm.Label;
import org.eclipse.escet.common.dsm.app.ConvergenceOption;
import org.eclipse.escet.common.dsm.app.DsmBusDetectionAlgorithmOption;
import org.eclipse.escet.common.dsm.app.DsmBusFactorOption;
import org.eclipse.escet.common.dsm.app.DsmEvaporationOption;
import org.eclipse.escet.common.dsm.app.DsmInflationOption;
import org.eclipse.escet.common.dsm.app.DsmStepCountOption;
import org.eclipse.escet.common.dsm.app.OutputGroupsOption;
import org.eclipse.escet.common.dsm.io.ReadMatrix;
import org.eclipse.escet.common.dsm.io.WriteMatrix;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.output.DebugNormalOutput;

public class DsmApplication
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        DsmApplication app = new DsmApplication();
        app.run(args, true);
    }

    public DsmApplication() {
    }

    public DsmApplication(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "DSM clustering tool";
    }

    public String getAppDescription() {
        return "Clusters nodes in a graph and generates a DSM with a bus and clusters.";
    }

    public String getAppToolDefLibName() {
        return "escet";
    }

    public String getAppToolDefToolName() {
        return "dsmclustering";
    }

    protected int runInternal() {
        String inPath = Paths.resolve((String)InputFileOption.getPath());
        ClusterInput inputData = ReadMatrix.readMatrixFile((String)inPath, (DebugNormalOutput)this.getAppEnvData().getProvider().getDebugOutputStream());
        inputData.evap = DsmEvaporationOption.getEvaporationFactor();
        inputData.inflation = DsmInflationOption.getInflationFactor();
        inputData.busDetectionAlgorithm = DsmBusDetectionAlgorithmOption.getBusAlgorithm();
        inputData.busInclusion = DsmBusFactorOption.getBusFactor();
        inputData.epsilon = ConvergenceOption.getConvergenceValue();
        inputData.stepCount = DsmStepCountOption.getStepCountValue();
        Dsm dsm = DsmClustering.flowBasedMarkovClustering((ClusterInput)inputData);
        String outPath = OutputFileOption.getDerivedPath((String)".dsm", (String)"_out.dsm");
        String absOutPath = Paths.resolve((String)outPath);
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileAppStream stream = new FileAppStream(outPath, absOutPath);){
            Label[] labels = (Label[])DsmHelper.shuffleArray((Object[])inputData.labels, (int[])dsm.nodeShuffle);
            WriteMatrix.writeMatrixFile((AppStream)stream, (RealMatrix)dsm.adjacencies, (Label[])labels);
            if (OutputGroupsOption.getOutputGroupsOptionValue()) {
                WriteMatrix.writeGroups((AppStream)stream, (Group)dsm.rootGroup);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return 0;
    }

    protected OutputProvider<IOutputComponent> createProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalOpts = DsmApplication.getGeneralOptionCategory();
        OptionCategory clusterOpts = new OptionCategory("Clustering", "Options to steer the clustering algorithms.", Lists.list(), Lists.list((Object[])new Option[]{Options.getInstance(InputFileOption.class), Options.getInstance(OutputFileOption.class), Options.getInstance(DsmEvaporationOption.class), Options.getInstance(DsmInflationOption.class), Options.getInstance(DsmBusDetectionAlgorithmOption.class), Options.getInstance(DsmBusFactorOption.class), Options.getInstance(ConvergenceOption.class), Options.getInstance(OutputGroupsOption.class), Options.getInstance(DsmStepCountOption.class)}));
        OptionCategory options = new OptionCategory("DSM Clustering Tool Options", "All options for the DSM clustering tool.", Lists.list((Object[])new OptionCategory[]{generalOpts, clusterOpts}), Lists.list());
        return options;
    }
}

